﻿---
title: Rescorer retriever
description: The rescorer retriever re-scores only the results produced by its child retriever. For the standard and knn retrievers, the window_size parameter specifies...
url: https://www.elastic.co/docs/reference/elasticsearch/rest-apis/retrievers/rescorer-retriever
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Rescorer retriever
The `rescorer` retriever re-scores only the results produced by its child retriever. For the `standard` and `knn` retrievers, the `window_size` parameter specifies the number of documents examined per shard.
For compound retrievers like `rrf`, the `window_size` parameter defines the total number of documents examined globally.
When using the `rescorer`, an error is returned if the following conditions are not met:
- The minimum configured rescore’s `window_size` is:
  - Greater than or equal to the `size` of the parent retriever for nested `rescorer` setups.
- Greater than or equal to the `size` of the search request when used as the primary retriever in the tree.
- And the maximum rescore’s `window_size` is:
  - Smaller than or equal to the `size` or `rank_window_size` of the child retriever.


## Parameters

<definitions>
  <definition term="rescore">
    (Required. [A rescorer definition or an array of rescorer definitions](/docs/reference/elasticsearch/rest-apis/rescore-search-results#rescore))
    Defines the [rescorers](/docs/reference/elasticsearch/rest-apis/rescore-search-results#rescore) applied sequentially to the top documents returned by the child retriever.
  </definition>
  <definition term="retriever">
    (Required. `retriever`)
    Specifies the child retriever responsible for generating the initial set of top documents to be re-ranked.
  </definition>
  <definition term="filter">
    (Optional. [query object or list of query objects](https://www.elastic.co/docs/reference/query-languages/querydsl))
    Applies a [boolean query filter](https://www.elastic.co/docs/reference/query-languages/query-dsl/query-dsl-bool-query) to the retriever, ensuring that all documents match the filter criteria without affecting their scores.
  </definition>
</definitions>


## Example

The `rescorer` retriever can be placed at any level within the retriever tree. The following example demonstrates a `rescorer` applied to the results produced by an `rrf` retriever:
```json

{
  "size": 10, <1>
  "retriever": {
    "rescorer": { <2>
      "rescore": {
        "window_size": 50, <3>
        "query": { <4>
          "rescore_query": {
            "script_score": {
              "query": {
                "match_all": {}
              },
              "script": {
                "source": "cosineSimilarity(params.queryVector, 'product-vector_final_stage') + 1.0",
                "params": {
                  "queryVector": [-0.5, 90.0, -10, 14.8, -156.0]
                }
              }
            }
          }
        }
      },
      "retriever": { <5>
        "rrf": {
          "rank_window_size": 100, <6>
          "retrievers": [
            {
              "standard": {
                "query": {
                  "sparse_vector": {
                    "field": "plot_embedding",
                    "inference_id": "my-elser-model",
                    "query": "films that explore psychological depths"
                  }
                }
              }
            },
            {
              "standard": {
                "query": {
                  "multi_match": {
                    "query": "crime",
                    "fields": [
                      "plot",
                      "title"
                    ]
                  }
                }
              }
            },
            {
              "knn": {
                "field": "vector",
                "query_vector": [10, 22, 77],
                "k": 10,
                "num_candidates": 10
              }
            }
          ]
        }
      }
    }
  }
}
```