﻿---
title: Pinned retriever
description: A pinned retriever returns top documents by always placing specific documents at the top of the results, with the remaining hits provided by a secondary...
url: https://www.elastic.co/docs/reference/elasticsearch/rest-apis/retrievers/pinned-retriever
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available since 9.1
---

# Pinned retriever
A `pinned` retriever returns top documents by always placing specific documents at the top of the results, with the remaining hits provided by a secondary retriever.
This retriever offers similar functionality to the [pinned query](https://www.elastic.co/docs/reference/query-languages/query-dsl/query-dsl-pinned-query), but works seamlessly with other retrievers. This is useful for promoting certain documents for particular queries, regardless of their relevance score.

## Parameters

<definitions>
  <definition term="ids">
    (Optional, array of strings)
    A list of document IDs to pin at the top of the results, in the order provided.
  </definition>
  <definition term="docs">
    (Optional, array of objects)
    A list of objects specifying documents to pin. Each object must contain at least an `_id` field, and may also specify `_index` if pinning documents across multiple indices.
  </definition>
  <definition term="retriever">
    (Optional, retriever object)
    A retriever (for example a `standard` retriever or a specialized retriever such as `rrf` retriever) used to retrieve the remaining documents after the pinned ones.
  </definition>
</definitions>

Either `ids` or `docs` must be specified.

## Example using `docs`

```json

{
  "retriever": {
    "pinned": {
      "docs": [
        { "_id": "doc1", "_index": "my-index" },
        { "_id": "doc2" }
      ],
      "retriever": {
        "standard": {
          "query": {
            "match": {
              "title": "elasticsearch"
            }
          }
        }
      }
    }
  }
}
```