﻿---
title: kNN retriever
description: A kNN retriever returns top documents from a k-nearest neighbor search (kNN). See oversampling and rescoring quantized vectors for details. The parameters...
url: https://www.elastic.co/docs/reference/elasticsearch/rest-apis/retrievers/knn-retriever
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# kNN retriever
A kNN retriever returns top documents from a [k-nearest neighbor search (kNN)](https://www.elastic.co/docs/solutions/search/vector/knn).

## Parameters

<definitions>
  <definition term="field">
    (Required, string)
    The name of the vector field to search against. Must be a [`dense_vector` field with indexing enabled](/docs/reference/elasticsearch/mapping-reference/dense-vector#index-vectors-knn-search).
  </definition>
  <definition term="query_vector">
    (Required if `query_vector_builder` is not defined, array of `float`)
    Query vector. Must have the same number of dimensions as the vector field you are searching against. Must be either an array of floats or a hex-encoded byte vector.
  </definition>
  <definition term="query_vector_builder">
    (Required if `query_vector` is not defined, query vector builder object)
    Defines a [model](https://www.elastic.co/docs/solutions/search/vector/knn#knn-semantic-search) to build a query vector.
  </definition>
  <definition term="k">
    (Required, integer)
    Number of nearest neighbors to return as top hits. This value must be fewer than or equal to `num_candidates`.
  </definition>
  <definition term="num_candidates">
    (Required, integer)
    The number of nearest neighbor candidates to consider per shard. Needs to be greater than `k`, or `size` if `k` is omitted, and cannot exceed 10,000. Elasticsearch collects `num_candidates` results from each shard, then merges them to find the top `k` results. Increasing `num_candidates` tends to improve the accuracy of the final `k` results. Defaults to `Math.min(1.5 * k, 10_000)`.
  </definition>
  <definition term="visit_percentage Elastic Stack: Generally available since 9.2">
    (Optional, float)
    The percentage of vectors to explore per shard while doing knn search with `bbq_disk`. Must be between 0 and 100.  0 will default to using `num_candidates` for calculating the percent visited. Increasing `visit_percentage` tends to improve the accuracy of the final results.  If `visit_percentage` is set for `bbq_disk`, `num_candidates` is ignored. Defaults to ~1% per shard for every 1 million vectors.
  </definition>
  <definition term="filter">
    (Optional, [query object or list of query objects](https://www.elastic.co/docs/reference/query-languages/querydsl))
    Query to filter the documents that can match. The kNN search will return the top `k` documents that also match this filter. The value can be a single query or a list of queries. If `filter` is not provided, all documents are allowed to match.
  </definition>
  <definition term="similarity">
    (Optional, float)
    The minimum similarity required for a document to be considered a match. The similarity value calculated relates to the raw [`similarity`](/docs/reference/elasticsearch/mapping-reference/dense-vector#dense-vector-similarity) used. Not the document score. The matched documents are then scored according to [`similarity`](/docs/reference/elasticsearch/mapping-reference/dense-vector#dense-vector-similarity) and the provided `boost` is applied.
    The `similarity` parameter is the direct vector similarity calculation.
    - `l2_norm`: also known as Euclidean, will include documents where the vector is within the `dims` dimensional hypersphere with radius `similarity` with origin at `query_vector`.
    - `cosine`, `dot_product`, and `max_inner_product`: Only return vectors where the cosine similarity or dot-product are at least the provided `similarity`.
    Read more here: [knn similarity search](https://www.elastic.co/docs/solutions/search/vector/knn#knn-similarity-search)
  </definition>
  <definition term="rescore_vector Elastic Stack: Generally available since 9.1, Elastic Stack: Preview in 9.0">
    (Optional, object) Apply oversampling and rescoring to quantized vectors.
  </definition>
</definitions>

<note>
  Rescoring only makes sense for quantized vectors; when [quantization](/docs/reference/elasticsearch/mapping-reference/dense-vector#dense-vector-quantization) is not used, the original vectors are used for scoring. Rescore option will be ignored for non-quantized `dense_vector` fields.
</note>

<definitions>
  <definition term="oversample">
    (Required, float)
    Applies the specified oversample factor to `k` on the approximate kNN search. The approximate kNN search will:
    - Retrieve `num_candidates` candidates per shard.
    - From these candidates, the top `k * oversample` candidates per shard will be rescored using the original vectors.
    - The top `k` rescored candidates will be returned.
  </definition>
</definitions>

See [oversampling and rescoring quantized vectors](https://www.elastic.co/docs/solutions/search/vector/knn#dense-vector-knn-search-rescoring) for details.

## Restrictions

The parameters `query_vector` and `query_vector_builder` cannot be used together.

## Example

```json

{
  "retriever": {
    "knn": { <1>
      "field": "vector", <2>
      "query_vector": [10, 22, 77], <3>
      "k": 10, <4>
      "num_candidates": 10 <5>
    }
  }
}
```