﻿---
title: Retrievers
description: A retriever is a specification to describe top documents returned from a search. A retriever replaces other elements of the search API that also return...
url: https://www.elastic.co/docs/reference/elasticsearch/rest-apis/retrievers
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Retrievers
A retriever is a specification to describe top documents returned from a search. A retriever replaces other elements of the [search API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-search) that also return top documents such as [`query`](https://www.elastic.co/docs/reference/query-languages/querydsl) and [`knn`](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-search#search-api-knn). A retriever may have child retrievers where a retriever with two or more children is considered a compound retriever. This allows for complex behavior to be depicted in a tree-like structure, called the retriever tree, which clarifies the order of operations that occur during a search.
<tip>
  Refer to [*Retrievers*](https://www.elastic.co/docs/solutions/search/retrievers-overview) for a high level overview of the retrievers abstraction. Refer to [Retrievers examples](https://www.elastic.co/docs/reference/elasticsearch/rest-apis/retrievers/retrievers-examples) for additional examples.
</tip>

The following retrievers are available:
<definitions>
  <definition term="diversify Elastic Cloud Serverless: Preview Elastic Stack: Preview since 9.3">
    The [diversify](https://www.elastic.co/docs/reference/elasticsearch/rest-apis/retrievers/diversify-retriever) retriever reduces the results from another retriever by applying a diversification strategy to the top-N results.
  </definition>
  <definition term="knn">
    The [knn](https://www.elastic.co/docs/reference/elasticsearch/rest-apis/retrievers/knn-retriever) retriever replaces the functionality of a [knn search](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-search#search-api-knn).
  </definition>
  <definition term="linear">
    The [linear](https://www.elastic.co/docs/reference/elasticsearch/rest-apis/retrievers/linear-retriever) retriever linearly combines the scores of other retrievers for the top documents.
  </definition>
  <definition term="pinned Elastic Stack: Generally available since 9.1">
    The [pinned](https://www.elastic.co/docs/reference/elasticsearch/rest-apis/retrievers/pinned-retriever) retriever always places specified documents at the top of the results, with the remaining hits provided by a secondary retriever.
  </definition>
  <definition term="rescorer">
    The [rescorer](https://www.elastic.co/docs/reference/elasticsearch/rest-apis/retrievers/rescorer-retriever) retriever replaces the functionality of the [query rescorer](/docs/reference/elasticsearch/rest-apis/rescore-search-results#rescore).
  </definition>
  <definition term="rrf">
    The [rrf](https://www.elastic.co/docs/reference/elasticsearch/rest-apis/retrievers/rrf-retriever) retriever produces top documents from [reciprocal rank fusion (RRF)](https://www.elastic.co/docs/reference/elasticsearch/rest-apis/reciprocal-rank-fusion).
  </definition>
  <definition term="rule">
    The [rule](https://www.elastic.co/docs/reference/elasticsearch/rest-apis/retrievers/rule-retriever) retriever applies contextual [Searching with query rules](/docs/reference/elasticsearch/rest-apis/searching-with-query-rules#query-rules) to pin or exclude documents for specific queries.
  </definition>
  <definition term="standard">
    The [standard](https://www.elastic.co/docs/reference/elasticsearch/rest-apis/retrievers/standard-retriever) retriever replaces the functionality of a traditional [query](https://www.elastic.co/docs/reference/query-languages/querydsl).
  </definition>
  <definition term="text_similarity_reranker">
    The [text_similarity_reranker](https://www.elastic.co/docs/reference/elasticsearch/rest-apis/retrievers/text-similarity-reranker-retriever) retriever enhances search results by re-ranking documents based on semantic similarity to a specified inference text, using a machine learning model.
  </definition>
</definitions>


## Common usage guidelines


### Using `from` and `size` with a retriever tree

The [`from`](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-search#search-from-param) and [`size`](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-search#search-size-param) parameters are provided globally as part of the general [search API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-search). They are applied to all retrievers in a retriever tree, unless a specific retriever overrides the `size` parameter using a different parameter such as `rank_window_size`. Though, the final search hits are always limited to `size`.

### Using aggregations with a retriever tree

[Aggregations](https://www.elastic.co/docs/reference/aggregations) are globally specified as part of a search request. The query used for an aggregation is the combination of all leaf retrievers as `should` clauses in a [boolean query](https://www.elastic.co/docs/reference/query-languages/query-dsl/query-dsl-bool-query).

### Restrictions on search parameters when specifying a retriever

When a retriever is specified as part of a search, the following elements are not allowed at the top-level:
- [`query`](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-search#request-body-search-query)
- [`knn`](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-search#search-api-knn)
- [`search_after`](/docs/reference/elasticsearch/rest-apis/paginate-search-results#search-after)
- [`terminate_after`](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-search#request-body-search-terminate-after)
- [`sort`](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-search#search-sort-param)
- [`rescore`](/docs/reference/elasticsearch/rest-apis/rescore-search-results#rescore) use a [rescorer retriever](https://www.elastic.co/docs/reference/elasticsearch/rest-apis/retrievers/rescorer-retriever) instead


## Multi-field query format

<applies-to>
  - Elastic Stack: Generally available since 9.1
</applies-to>

The [`linear`](https://www.elastic.co/docs/reference/elasticsearch/rest-apis/retrievers/linear-retriever) and [`rrf`](https://www.elastic.co/docs/reference/elasticsearch/rest-apis/retrievers/rrf-retriever) retrievers support a multi-field query format that provides a simplified way to define searches across multiple fields without explicitly specifying inner retrievers.
This format automatically generates appropriate inner retrievers based on the field types and query parameters.
This is a great way to search an index, knowing little to nothing about its schema, while also handling normalization across lexical and semantic matches.

### Field grouping

The multi-field query format groups queried fields into two categories:
- **Lexical fields**: fields that support term queries, such as `keyword` and `text` fields.
- **Semantic fields**: [`semantic_text` fields](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/semantic-text).

Each field group is queried separately and the scores/ranks are normalized such that each contributes 50% to the final score/rank.
This balances the importance of lexical and semantic fields.
Most indices contain more lexical than semantic fields, and without this grouping the results would often bias towards lexical field matches.
<warning>
  In the `linear` retriever, this grouping relies on using a normalizer other than `none` (i.e., `minmax` or `l2_norm`).
  If you use the `none` normalizer, the scores across field groups will not be normalized and the results may be biased towards lexical field matches.
</warning>


### Linear retriever field boosting

When using the `linear` retriever, fields can be boosted using the `^` notation:
```json

{
  "retriever": {
    "linear": {
      "query": "elasticsearch",
      "fields": [
        "title^3",                <1>
        "description^2",          <2>
        "title_semantic",         <3>
        "description_semantic^2"
      ],
      "normalizer": "minmax"
    }
  }
}
```

Due to how the [field group scores](#multi-field-field-grouping) are normalized, per-field boosts have no effect on the range of the final score.
Instead, they affect the importance of the field's score within its group.
For example, if the schema looks like:
```json

{
  "mappings": {
    "properties": {
      "title": {
        "type": "text",
        "copy_to": "title_semantic"
      },
      "description": {
        "type": "text",
        "copy_to": "description_semantic"
      },
      "title_semantic": {
        "type": "semantic_text"
      },
      "description_semantic": {
        "type": "semantic_text"
      }
    }
  }
}
```

And we run this query:
```json

{
  "retriever": {
    "linear": {
      "query": "elasticsearch",
      "fields": [
        "title",
        "description",
        "title_semantic",
        "description_semantic"
      ],
      "normalizer": "minmax"
    }
  }
}
```

The score breakdown would be:
- Lexical fields (50% of score):
  - `title`: 50% of lexical fields group score, 25% of final score
- `description`: 50% of lexical fields group score, 25% of final score
- Semantic fields (50% of score):
  - `title_semantic`: 50% of semantic fields group score, 25% of final score
- `description_semantic`: 50% of semantic fields group score, 25% of final score

If we apply per-field boosts like so:
```json

{
  "retriever": {
    "linear": {
      "query": "elasticsearch",
      "fields": [
        "title^3",
        "description^2",
        "title_semantic",
        "description_semantic^2"
      ],
      "normalizer": "minmax"
    }
  }
}
```

The score breakdown would change to:
- Lexical fields (50% of score):
  - `title`: 60% of lexical fields group score, 30% of final score
- `description`: 40% of lexical fields group score, 20% of final score
- Semantic fields (50% of score):
  - `title_semantic`: 33% of semantic fields group score, 16.5% of final score
- `description_semantic`: 66% of semantic fields group score, 33% of final score


### Wildcard field patterns

Field names support the `*` wildcard character to match multiple fields:
```json

{
  "retriever": {
    "rrf": {
      "query": "machine learning",
      "fields": [
        "title*",    <1>
        "*_text"     <2>
      ]
    }
  }
}
```

Note, however, that wildcard field patterns will only resolve to fields that either:
- Support term queries, such as `keyword` and `text` fields
- Are `semantic_text` fields


### Limitations

- **Single index**: Until 9.2, multi-field queries only work with single index searches.
- **CCS (Cross Cluster Search)**: Multi-field queries do not support remote cluster searches


### Examples

- [RRF with the multi-field query format](/docs/reference/elasticsearch/rest-apis/retrievers/retrievers-examples#retrievers-examples-rrf-multi-field-query-format)
- [Linear retriever with the multi-field query format](/docs/reference/elasticsearch/rest-apis/retrievers/retrievers-examples#retrievers-examples-linear-multi-field-query-format)