﻿---
title: Retrieve stored fields using the Get document API
description: You can use the Get API's stored_fields parameter to retrieve fields marked as stored ("store": true) in the index mapping. Fields not marked as stored...
url: https://www.elastic.co/docs/reference/elasticsearch/rest-apis/retrieve-stored-fields
products:
  - Elasticsearch
applies_to:
  - Elastic Stack: Generally available
---

# Retrieve stored fields using the Get document API
You can use the Get API's [`stored_fields` parameter](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-get#operation-get-stored_fields) to retrieve fields marked as stored (`"store": true`) in the index mapping.
Fields not marked as stored are excluded from the response, even if specified in the request.
<tip>
  In most cases, the [`fields`](/docs/reference/elasticsearch/rest-apis/retrieve-selected-fields#search-fields-param) and [`_source`](/docs/reference/elasticsearch/rest-apis/retrieve-selected-fields#source-filtering) parameters produce better results than `stored_fields`.
</tip>

For example, these PUT requests define a stored field in the mapping and add a document:
```json

{
  "mappings": {
    "properties": {
      "counter": {
        "type": "integer",
        "store": false
      },
      "tags": {
        "type": "keyword",
        "store": true
      }
    }
  }
}
```

```json

{
  "counter": 1,
  "tags": [ "production" ]
}
```

This request retrieves the stored fields from the document:
```json
```

The API returns the following response:
```json
{
  "_index": "my-index-000001",
  "_id": "1",
  "_version": 1,
  "_seq_no": 0,
  "_primary_term": 1,
  "found": true,
  "fields": {
    "tags": [
      "production"
    ]
  }
}
```

Although the `counter` field is specified in the request, it's not included in the response because it's not actually a stored field.
Field values are returned as an array.
<note>
  Only leaf fields can be retrieved with the `stored_fields` parameter. If you specify an object field instead, an error is returned.
</note>