﻿---
title: Filter search results
description: You can use the search API to filter results using either boolean filter clauses or the post_filter parameter. Use a boolean query with a filter clause...
url: https://www.elastic.co/docs/reference/elasticsearch/rest-apis/filter-search-results
products:
  - Elasticsearch
applies_to:
  - Elastic Stack: Generally available
---

# Filter search results
You can use the [search API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-search) to filter results using either boolean `filter` clauses or the `post_filter` parameter.
- Use a boolean query with a `filter` clause. Search requests apply [boolean filters](https://www.elastic.co/docs/reference/query-languages/query-dsl/query-dsl-bool-query) to both search hits and [aggregations](https://www.elastic.co/docs/reference/aggregations).
- Use the search API’s `post_filter` parameter. Search requests apply [post filters](#post-filter) only to search hits, not aggregations. You can use a post filter to calculate aggregations based on a broader result set, and then further narrow the results.


## Post filter

When you use the `post_filter` parameter to filter search results, the search hits are filtered after the aggregations are calculated. A post filter has no impact on the aggregation results.
For example, you are selling shirts that have the following properties:
```json

{
  "mappings": {
    "properties": {
      "brand": { "type": "keyword"},
      "color": { "type": "keyword"},
      "model": { "type": "keyword"}
    }
  }
}


{
  "brand": "gucci",
  "color": "red",
  "model": "slim"
}
```

Imagine a user has specified two filters:
`color:red` and `brand:gucci`. You only want to show them red shirts made by Gucci in the search results. Normally you would do this with a [`bool` query](https://www.elastic.co/docs/reference/query-languages/query-dsl/query-dsl-bool-query):
```json

{
  "query": {
    "bool": {
      "filter": [
        { "term": { "color": "red"   }},
        { "term": { "brand": "gucci" }}
      ]
    }
  }
}
```

However, you would also like to use *faceted navigation* to display a list of other options that the user could click on. Perhaps you have a `model` field that would allow the user to limit their search results to red Gucci `t-shirts` or `dress-shirts`.
This can be done with a [`terms` aggregation](https://www.elastic.co/docs/reference/aggregations/search-aggregations-bucket-terms-aggregation):
```json

{
  "query": {
    "bool": {
      "filter": [
        { "term": { "color": "red"   }},
        { "term": { "brand": "gucci" }}
      ]
    }
  },
  "aggs": {
    "models": {
      "terms": { "field": "model" } <1>
    }
  }
}
```

But perhaps you would also like to tell the user how many Gucci shirts are available in **other colors**. If you just add a `terms` aggregation on the `color` field, you will only get back the color `red`, because your query returns only red shirts by Gucci.
Instead, you want to include shirts of all colors during aggregation, then apply the `colors` filter only to the search results. This is the purpose of the `post_filter`:
```json

{
  "query": {
    "bool": {
      "filter": {
        "term": { "brand": "gucci" } <1>
      }
    }
  },
  "aggs": {
    "colors": {
      "terms": { "field": "color" } <2>
    },
    "color_red": {
      "filter": {
        "term": { "color": "red" } <3>
      },
      "aggs": {
        "models": {
          "terms": { "field": "model" } <3>
        }
      }
    }
  },
  "post_filter": { <4>
    "term": { "color": "red" }
  }
}
```