﻿---
title: Use the explain lifecycle API to understand the index lifecycle status
description: The explain lifecycle API retrieves the current lifecycle status for one or more indices. For data streams, the API retrieves the lifecycle status for...
url: https://www.elastic.co/docs/reference/elasticsearch/rest-apis/explain-lifecycle
products:
  - Elasticsearch
applies_to:
  - Elastic Stack: Generally available
---

# Use the explain lifecycle API to understand the index lifecycle status
The [explain lifecycle API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-ilm-explain-lifecycle) retrieves the current lifecycle status for one or more indices. For data streams, the API retrieves the lifecycle status for the stream’s backing indices, including the current phase, action, step, and any failures.

## Get the lifecycle status of an index

The following example retrieves the lifecycle state of `my-index-000001`:
```json
```

When management of the index is first taken over by ILM, `explain` shows that the index is managed and in the `new` phase:
```json
{
  "indices": {
    "my-index-000001": {
      "index": "my-index-000001",
      "index_creation_date_millis": 1538475653281,        
      "index_creation_date": "2018-10-15T13:45:21.981Z",
      "time_since_index_creation": "15s",                 
      "managed": true,                                    
      "policy": "my_policy",                              
      "lifecycle_date_millis": 1538475653281,             
      "lifecycle_date": "2018-10-15T13:45:21.981Z",
      "age": "15s",                                       
      "phase": "new",
      "phase_time_millis": 1538475653317,                 
      "phase_time": "2018-10-15T13:45:22.577Z",
      "action": "complete"
      "action_time_millis": 1538475653317,                
      "action_time": "2018-10-15T13:45:22.577Z",
      "step": "complete",
      "step_time_millis": 1538475653317,                  
      "step_time": "2018-10-15T13:45:22.577Z"
    }
  }
}
```


## View the phase definition applied to an index

Once the policy is running on the index, the response includes a `phase_execution` object that shows the definition of the current phase. Changes to the underlying policy will not affect this index until the current phase completes.
```json
{
  "indices": {
    "test-000069": {
      "index": "test-000069",
      "index_creation_date_millis": 1538475653281,
      "time_since_index_creation": "25.14s",
      "managed": true,
      "policy": "my_lifecycle3",
      "lifecycle_date_millis": 1538475653281,
      "lifecycle_date": "2018-10-15T13:45:21.981Z",
      "age": "25.14s",
      "phase": "hot",
      "phase_time_millis": 1538475653317,
      "phase_time": "2018-10-15T13:45:22.577Z",
      "action": "rollover",
      "action_time_millis": 1538475653317,
      "action_time": "2018-10-15T13:45:22.577Z",
      "step": "attempt-rollover",
      "step_time_millis": 1538475653317,
      "step_time": "2018-10-15T13:45:22.577Z",
      "phase_execution": {
        "policy": "my_lifecycle3",
        "phase_definition": { 
          "min_age": "0ms",
          "actions": {
            "rollover": {
              "max_age": "30s",
              "max_primary_shard_docs": 200000000, 
              "min_docs": 1
            }
          }
        },
        "version": 3, 
        "modified_date": "2018-10-15T13:21:41.576Z", 
        "modified_date_in_millis": 1539609701576 
      }
    }
  }
}
```


## Check the status of a running step

If ILM is waiting for a step to complete, the response includes status information for the step that's being performed on the index.
```json
{
  "indices": {
    "test-000020": {
      "index": "test-000020",
      "index_creation_date_millis": 1538475653281,
      "time_since_index_creation": "4.12m",
      "managed": true,
      "policy": "my_lifecycle3",
      "lifecycle_date_millis": 1538475653281,
      "lifecycle_date": "2018-10-15T13:45:21.981Z",
      "age": "4.12m",
      "phase": "warm",
      "phase_time_millis": 1538475653317,
      "phase_time": "2018-10-15T13:45:22.577Z",
      "action": "allocate",
      "action_time_millis": 1538475653317,
      "action_time": "2018-10-15T13:45:22.577Z",
      "step": "check-allocation",
      "step_time_millis": 1538475653317,
      "step_time": "2018-10-15T13:45:22.577Z",
      "step_info": { 
        "message": "Waiting for all shard copies to be active",
        "shards_left_to_allocate": -1,
        "all_shards_active": false,
        "number_of_replicas": 2
      },
      "phase_execution": {
        "policy": "my_lifecycle3",
        "phase_definition": {
          "min_age": "0ms",
          "actions": {
            "allocate": {
              "number_of_replicas": 2,
              "include": {
                "box_type": "warm"
              },
              "exclude": {},
              "require": {}
            },
            "forcemerge": {
              "max_num_segments": 1
            }
          }
        },
        "version": 2,
        "modified_date": "2018-10-15T13:20:02.489Z",
        "modified_date_in_millis": 1539609602489
      }
    }
  }
}
```


## Diagnose lifecycle errors

If the index is in the ERROR step, something went wrong while executing a step in the policy and you will need to take action for the index to proceed
to the next step. Some steps are safe to automatically be retried in certain circumstances. To help you diagnose the problem, the explain response shows the step that failed, the step info which provides information about the error, and information about the retry attempts executed for the failed step if it's the case.
```json
{
  "indices": {
    "test-000056": {
      "index": "test-000056",
      "index_creation_date_millis": 1538475653281,
      "time_since_index_creation": "50.1d",
      "managed": true,
      "policy": "my_lifecycle3",
      "lifecycle_date_millis": 1538475653281,
      "lifecycle_date": "2018-10-15T13:45:21.981Z",
      "age": "50.1d",
      "phase": "hot",
      "phase_time_millis": 1538475653317,
      "phase_time": "2018-10-15T13:45:22.577Z",
      "action": "rollover",
      "action_time_millis": 1538475653317,
      "action_time": "2018-10-15T13:45:22.577Z",
      "step": "ERROR",
      "step_time_millis": 1538475653317,
      "step_time": "2018-10-15T13:45:22.577Z",
      "failed_step": "check-rollover-ready", 
      "is_auto_retryable_error": true, 
      "failed_step_retry_count": 1, 
      "step_info": { 
        "type": "cluster_block_exception",
        "reason": "index [test-000057/H7lF9n36Rzqa-KfKcnGQMg] blocked by: [FORBIDDEN/5/index read-only (api)",
        "index_uuid": "H7lF9n36Rzqa-KfKcnGQMg",
        "index": "test-000057"
      },
      "previous_step_info": { 
        "type": "cluster_block_exception",
        "reason": "index [test-000057/H7lF9n36Rzqa-KfKcnGQMg] blocked by: [FORBIDDEN/5/index read-only (api)",
        "index_uuid": "H7lF9n36Rzqa-KfKcnGQMg",
        "index": "test-000057"
      },
      "phase_execution": {
        "policy": "my_lifecycle3",
        "phase_definition": {
          "min_age": "0ms",
          "actions": {
            "rollover": {
              "max_age": "30s"
            }
          }
        },
        "version": 3,
        "modified_date": "2018-10-15T13:21:41.576Z",
        "modified_date_in_millis": 1539609701576
      }
    }
  }
}
```