﻿---
title: Elasticsearch API compatibility
description: To help REST clients mitigate the impact of non-compatible (breaking) API changes, Elasticsearch provides a per-request, opt-in API compatibility mode...
url: https://www.elastic.co/docs/reference/elasticsearch/rest-apis/compatibility
products:
  - Elasticsearch
applies_to:
  - Elastic Stack: Generally available
---

# Elasticsearch API compatibility
To help REST clients mitigate the impact of non-compatible (breaking) API changes, Elasticsearch provides a per-request, opt-in API compatibility mode.
Elasticsearch REST APIs are generally stable across versions. However, some improvements require changes that are not compatible with previous versions.
When an API is targeted for removal or is going to be changed in a non-compatible way, the original API is deprecated for one or more releases. Using the original API triggers a deprecation warning in the logs. This enables you to review the deprecation logs  and take the appropriate actions before upgrading. However, in some cases it is difficult to identify all places where deprecated APIs are being used. This is where REST API compatibility can help.
When you request REST API compatibility, Elasticsearch attempts to honor the previous REST API version. Elasticsearch attempts to apply the most compatible URL, request body, response body, and HTTP parameters.
For compatible APIs, this has no effect— it only impacts calls to APIs that have breaking changes from the previous version. An error can still be returned in compatibility mode if Elasticsearch cannot automatically resolve the incompatibilities.
<important>
  REST API compatibility does not guarantee the same behavior as the prior version. It instructs Elasticsearch to automatically resolve any incompatibilities so the request can be processed instead of returning an error.
</important>

REST API compatibility should be a bridge to smooth out the upgrade process, not a long term strategy. REST API compatibility is only honored across one major version: honor 8.x requests/responses from 9.x.
When you submit requests using REST API compatibility and Elasticsearch resolves the incompatibility, a message is written to the deprecation log with the category "compatible_api". Review the deprecation log to identify any gaps in usage and fully supported features.

## Requesting REST API compatibility

REST API compatibility is implemented per request via the Accept and/or Content-Type headers.
For example:
```text
Accept: "application/vnd.elasticsearch+json;compatible-with=8"
Content-Type: "application/vnd.elasticsearch+json;compatible-with=8"
```

The Accept header is always required and the Content-Type header is only required when a body is sent with the request. The following values are valid when communicating with a 8.x or 9.x Elasticsearch server:
```text
"application/vnd.elasticsearch+json;compatible-with=8"
"application/vnd.elasticsearch+yaml;compatible-with=8"
"application/vnd.elasticsearch+smile;compatible-with=8"
"application/vnd.elasticsearch+cbor;compatible-with=8"
```

The [officially supported Elasticsearch clients](https://www.elastic.co/guide/en/elasticsearch/client/index.html) can enable REST API compatibility for all requests.
To enable REST API compatibility for all requests received by Elasticsearch set the environment variable `ELASTIC_CLIENT_APIVERSIONING` to true.

## REST API compatibility workflow

To leverage REST API compatibility during an upgrade from the last 8.x to 9.3.0:
1. Upgrade your [Elasticsearch clients](https://www.elastic.co/guide/en/elasticsearch/client/index.html) to the latest 8.x version and enable REST API compatibility.
2. Use the [Upgrade Assistant](https://www.elastic.co/docs/deploy-manage/upgrade/prepare-to-upgrade/upgrade-assistant) to review all critical issues and explore the deprecation logs. Some critical issues might be mitigated by REST API compatibility.
3. Resolve all critical issues before proceeding with the upgrade.
4. Upgrade Elasticsearch to 9.3.0.
5. Review the deprecation logs for entries with the category `compatible_api`. Review the workflow associated with the requests that relied on compatibility mode.
6. Upgrade your Elasticsearch clients to 9.x and resolve compatibility issues manually where needed.