﻿---
title: Plugin management
description: Plugins extend Elasticsearch’s core functionality and can be managed differently depending on the deployment type. While Elastic Cloud Enterprise (ECE)...
url: https://www.elastic.co/docs/reference/elasticsearch/plugins/plugin-management
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Serverless: Unavailable
  - Elastic Cloud Hosted: Generally available
  - Elastic Cloud Enterprise: Generally available
  - Self-managed Elastic deployments: Generally available
---

# Plugin management
Plugins extend Elasticsearch’s core functionality and can be managed differently depending on the deployment type. While Elastic Cloud Enterprise (ECE) and Elastic Cloud Hosted (ECH) provide built-in plugin management, self-managed deployments require manual installation.
Elastic Cloud Enterprise and Elastic Cloud Hosted deployments simplify plugin management by offering compatible plugins for your Elasticsearch version. These plugins are automatically upgraded with your deployment, except in cases of breaking changes.
In ECE and ECH deployments, you can add plugins by selecting them from the available list. However, plugin availability depends on the Elasticsearch version.
Plugins serve various purposes, including:
- National language support, phonetic analysis, and extended unicode support
- Ingesting attachments in common formats and ingesting information about the geographic location of IP addresses
- Adding new field datatypes to Elasticsearch
- Discovery plugins, such as the cloud AWS plugin that allows discovering nodes on EC2 instances.
- Analysis plugins, to provide analyzers targeted at languages other than English.
- Scripting plugins, to provide additional scripting languages.


## Managing plugins for ECE

<applies-to>
  - Elastic Cloud Enterprise: Generally available
</applies-to>


### Add plugins when creating a new ECE deployment

1. [Log into the Cloud UI](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/log-into-cloud-ui) and select **Create deployment**.
2. Make your initial deployment selections, then select **Customize Deployment**.
3. Beneath the Elasticsearch master node, expand the **Manage plugins and settings** caret.
4. Select the plugins you want.
5. Select **Create deployment**.

The deployment spins up with the plugins installed.

### Add plugins to an existing ECE deployment

1. [Log into the Cloud UI](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/log-into-cloud-ui).
2. On the **Deployments** page, select your deployment.
   Narrow the list by name, ID, or choose from several other filters. To further define the list, use a combination of filters.
3. From your deployment menu, go to the **Edit** page.
4. Beneath the Elasticsearch master node, expand the **Manage plugins and settings** caret.
5. Select the plugins that you want.
6. Select **Save changes**.

There is no downtime when adding plugins to highly available deployments. The deployment is updated with new nodes that have the plugins installed.

## Managing plugins for ECH

<applies-to>
  - Elastic Cloud Hosted: Generally available
</applies-to>

There are two ways to add plugins to Elastic Cloud Hosted deployments:
- Enable one of the official plugins already available in ECH
- [Upload a custom plugin and then enable it per deployment](https://www.elastic.co/docs/reference/elasticsearch/plugins/cloud/ec-custom-bundles).

Custom plugins can include the official Elasticsearch plugins not provided with ECH, any of the community-sourced plugins, or [plugins that you write yourself](https://www.elastic.co/docs/extend/elasticsearch). Uploading custom plugins is available only to Gold, Platinum, and Enterprise subscriptions. For more information, check [Upload custom plugins and bundles](https://www.elastic.co/docs/reference/elasticsearch/plugins/cloud/ec-custom-bundles).
To learn more about the official and community-sourced plugins, refer to [Elasticsearch Plugins and Integrations](https://www.elastic.co/docs/reference/elasticsearch/plugins).
For a detailed guide with examples of using the Elasticsearch Service API to create, get information about, update, and delete extensions and plugins, check [Managing plugins and extensions through the API](https://www.elastic.co/docs/reference/elasticsearch/plugins/cloud/ec-plugins-guide).

### Add plugins provided with ECH

You can use a variety of official plugins that are compatible with your version of Elasticsearch. When you upgrade to a new Elasticsearch version, these plugins are simply upgraded with the rest of your deployment.

#### Before you begin

Some restrictions apply when adding plugins. To learn more, check [Restrictions for Elasticsearch and Kibana plugins](https://www.elastic.co/docs/release-notes/cloud-hosted/known-issues#ec-restrictions-plugins).
Only Gold, Platinum, Enterprise and Private subscriptions have access to uploading custom plugins. All subscription levels, including Standard, can upload scripts and dictionaries.

### Enabling plugins for a deployment

1. Log in to the [Elastic Cloud Console](https://cloud.elastic.co?page=docs&placement=docs-body).
2. Find your deployment On the home page and select **Manage** next to it, or go to the **Deployments** page to view all deployments.
   On the **Deployments** page you can narrow your deployments by name, ID, or choose from several other filters. To customize your view, use a combination of filters, or change the format from a grid to a list.
3. From the **Actions** dropdown, select **Edit deployment**.
4. Select **Manage user settings and extensions**.
5. Select the **Extensions** tab.
6. Select the plugins that you want to enable.
7. Select **Back**.
8. Select **Save**. The Elasticsearch cluster is then updated with new nodes that have the plugin installed.


## Managing plugins for self-managed deployments

<applies-to>
  - Self-managed Elastic deployments: Generally available
</applies-to>

Use the `elasticsearch-plugin` command line tool to install, list, and remove plugins. It is located in the `$ES_HOME/bin` directory by default but it may be in a different location depending on which Elasticsearch package you installed. For more information, see [Plugins directory](https://www.elastic.co/docs/reference/elasticsearch/plugins/_plugins_directory)
Run the following command to get usage instructions:
```
sudo bin/elasticsearch-plugin -h
```

<important>
  If Elasticsearch was installed using the deb or rpm package then run `/usr/share/elasticsearch/bin/elasticsearch-plugin` as `root` so it can write to the appropriate files on disk. Otherwise run `bin/elasticsearch-plugin` as the user that owns all of the Elasticsearch files.
</important>

For detailed instructions on installing, managing, and configuring plugins, see the following:
- [Installing Plugins](https://www.elastic.co/docs/reference/elasticsearch/plugins/installation)
- [Custom URL or file system](https://www.elastic.co/docs/reference/elasticsearch/plugins/plugin-management-custom-url)
- [Installing multiple plugins](https://www.elastic.co/docs/reference/elasticsearch/plugins/installing-multiple-plugins)
- [Mandatory plugins](https://www.elastic.co/docs/reference/elasticsearch/plugins/mandatory-plugins)
- [Listing, removing and updating installed plugins](https://www.elastic.co/docs/reference/elasticsearch/plugins/listing-removing-updating)
- [Other command line parameters](https://www.elastic.co/docs/reference/elasticsearch/plugins/_other_command_line_parameters)
- [Manage plugins using a configuration file](https://www.elastic.co/docs/reference/elasticsearch/plugins/manage-plugins-using-configuration-file)


## Managing plugins for docker deployments

<applies-to>
  - Self-managed Elastic deployments: Generally available
</applies-to>

If you run Elasticsearch using Docker, you can manage plugins using a [configuration file](https://www.elastic.co/docs/reference/elasticsearch/plugins/manage-plugins-using-configuration-file).