﻿---
title: Microsoft Graph Authz
description: The Microsoft Graph Authz plugin uses Microsoft Graph to look up group membership information from Microsoft Entra ID. This is primarily intended to work...
url: https://www.elastic.co/docs/reference/elasticsearch/plugins/ms-graph-authz
products:
  - Elasticsearch
applies_to:
  - Elastic Stack: Generally available since 9.1
---

# Microsoft Graph Authz
The Microsoft Graph Authz plugin uses [Microsoft Graph](https://learn.microsoft.com/en-us/graph/api/user-list-memberof)
to look up group membership information from Microsoft Entra ID.
This is primarily intended to work around the Microsoft Entra ID maximum group
size limit (see [Group overages](https://learn.microsoft.com/en-us/security/zero-trust/develop/configure-tokens-group-claims-app-roles#group-overages)).

## Installation

If you're using a [self-managed Elasticsearch cluster](https://www.elastic.co/docs/deploy-manage/deploy/self-managed), then this plugin can be installed using the plugin manager:
```sh
sudo bin/elasticsearch-plugin install microsoft-graph-authz
```

The plugin must be installed on every node in the cluster, and each node must be
restarted after installation.
You can download this plugin
for [offline install](https://www.elastic.co/docs/reference/elasticsearch/plugins/plugin-management-custom-url)
from [[https://artifacts.elastic.co/downloads/elasticsearch-plugins/microsoft-graph-authz/microsoft-graph-authz-9.3.0.zip](https://artifacts.elastic.co/downloads/elasticsearch-plugins/microsoft-graph-authz/microsoft-graph-authz-9.3.0.zip)](https://artifacts.elastic.co/downloads/elasticsearch-plugins/microsoft-graph-authz/microsoft-graph-authz-9.3.0.zip).
To verify the `.zip` file, use
the [SHA hash](https://artifacts.elastic.co/downloads/elasticsearch-plugins/microsoft-graph-authz/microsoft-graph-authz-9.3.0.zip.sha512)
or [ASC key](https://artifacts.elastic.co/downloads/elasticsearch-plugins/microsoft-graph-authz/microsoft-graph-authz-9.3.0.zip.asc).
For all other deployment types, refer to [plugin management](https://www.elastic.co/docs/reference/elasticsearch/plugins/plugin-management).

## Removal

The plugin can be removed with the following command:
```sh
sudo bin/elasticsearch-plugin remove microsoft-graph-authz
```

The node must be stopped before removing the plugin.

## Configuration

To learn how to configure the Microsoft Graph Authz plugin, refer to [configuration properties](https://www.elastic.co/docs/reference/elasticsearch/plugins/ms-graph-authz-configure-elasticsearch).