﻿---
title: Configure Azure
description: To make API calls to Microsoft Graph, Elasticsearch requires Azure credentials with the correct permissions. Log in to the Azure portal and go to Microsoft...
url: https://www.elastic.co/docs/reference/elasticsearch/plugins/ms-graph-authz-configure-azure
products:
  - Elasticsearch
applies_to:
  - Elastic Stack: Generally available since 9.1
---

# Configure Azure
To make API calls to Microsoft Graph, Elasticsearch requires Azure credentials
with the correct permissions.

## Create a custom Azure application

1. Log in to the [Azure portal](https://portal.azure.com) and go to Microsoft
   Entra ID.
2. To register a new application, click **Enterprise applications** > **New
   application**.
3. Click **Create your own application**, provide a name, and select the
   **Integrate any other application you don’t find in the gallery** option.

!["create your own application" page](https://www.elastic.co/docs/reference/elasticsearch/plugins/images/ms-graph-authz/01-create-enterprise-application.png)


## Configure the custom application

1. In the [Azure portal](https://portal.azure.com), go to Microsoft Entra ID.
2. Under **App registrations**, select the **All applications** tab, and then
   find the application created in the previous section.
   ![find your app registration](https://www.elastic.co/docs/reference/elasticsearch/plugins/images/ms-graph-authz/02-find-app-registration.png)
3. Take note of the **Application (client) ID** and **Tenant ID** shown here.
   These will be needed to configure Elasticsearch later.
   ![get your application ID](https://www.elastic.co/docs/reference/elasticsearch/plugins/images/ms-graph-authz/03-get-application-id.png)
4. Under **Manage** > **Certificates & secrets**, do the following:
   - Create a new client secret.
- Take note of your new client secret's **Value**. This is needed later, and
  is only displayed once.
  ![get your client secret](https://www.elastic.co/docs/reference/elasticsearch/plugins/images/ms-graph-authz/04-create-client-secret.png)
5. Under **Manage** > **API permissions**, do the following:
   1. Go to **Add a permission**.
2. Choose **Microsoft Graph**.
3. Choose **Application permissions**.
4. Select `Directory.ReadWrite.All`, `Group.ReadWrite.All`, `User.Read.All`.
   <note>
   An Azure Admin must approve these permissions before the credentials can be used.
   </note>
   ![configure api permissions](https://www.elastic.co/docs/reference/elasticsearch/plugins/images/ms-graph-authz/05-configure-api-permissions.png)