﻿---
title: Using the _size field
description: In order to enable the _size field, set the mapping as follows: The value of the _size field is accessible in queries, aggregations, scripts, and when...
url: https://www.elastic.co/docs/reference/elasticsearch/plugins/mapper-size-usage
products:
  - Elasticsearch
---

# Using the _size field
In order to enable the `_size` field, set the mapping as follows:
```json

{
  "mappings": {
    "_size": {
      "enabled": true
    }
  }
}
```

The value of the `_size` field is accessible in queries, aggregations, scripts, and when sorting. It can be retrieved using the [fields parameter](/docs/reference/elasticsearch/rest-apis/retrieve-selected-fields#search-fields-param):
```json
# Example documents

{
  "text": "This is a document"
}


{
  "text": "This is another document"
}


{
  "query": {
    "range": {
      "_size": {                      <1>
        "gt": 10
      }
    }
  },
  "aggs": {
    "sizes": {
      "terms": {
        "field": "_size",             <2>
        "size": 10
      }
    }
  },
  "sort": [
    {
      "_size": {                      <3>
        "order": "desc"
      }
    }
  ],
  "fields": ["_size"],                <4>
  "script_fields": {
    "size": {
      "script": "doc['_size']"        <5>
    }
  }
}
```

<admonition title="Using _size in Kibana">
  To use the `_size` field in Kibana, update the `metaFields` setting and add `_size` to the list of meta fields. `metaFields` can be configured in Kibana from the Advanced Settings page in Management.
</admonition>