﻿---
title: Mapper plugins
description: Mapper plugins allow new field data types to be added to Elasticsearch. The core mapper plugins are: 
url: https://www.elastic.co/docs/reference/elasticsearch/plugins/mapper-plugins
products:
  - Elasticsearch
---

# Mapper plugins
Mapper plugins allow new field data types to be added to Elasticsearch.

## Core mapper plugins

The core mapper plugins are:
<definitions>
  <definition term="Mapper size plugin">
    The mapper-size plugin provides the `_size` metadata field which, when enabled, indexes the size in bytes of the original [`_source`](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/mapping-source-field) field.
  </definition>
  <definition term="Mapper murmur3 plugin">
    The mapper-murmur3 plugin allows hashes to be computed at index-time and stored in the index for later use with the `cardinality` aggregation.
  </definition>
  <definition term="Mapper annotated text plugin">
    The annotated text plugin provides the ability to index text that is a combination of free-text and special markup that is typically used to identify items of interest such as people or organisations (see NER or Named Entity Recognition tools).
  </definition>
</definitions>