﻿---
title: Manage plugins using a configuration file
description: If you run Elasticsearch using Docker, you can manage plugins using a declarative configuration file. When Elasticsearch starts up, it will compare the...
url: https://www.elastic.co/docs/reference/elasticsearch/plugins/manage-plugins-using-configuration-file
products:
  - Elasticsearch
applies_to:
  - Self-managed Elastic deployments: Generally available
---

# Manage plugins using a configuration file
<admonition title="Docker only">
  This feature is only available for [official Elasticsearch Docker images](https://www.docker.elastic.co/). Other Elasticsearch distributions will not start with a plugin configuration file.
</admonition>

If you run Elasticsearch using Docker, you can manage plugins using a declarative configuration file. When Elasticsearch starts up, it will compare the plugins in the file with those that are currently installed, and add or remove plugins as required. Elasticsearch will also upgrade official plugins when you upgrade Elasticsearch itself.
The file is called `elasticsearch-plugins.yml`, and must be placed in the Elasticsearch configuration directory, alongside `elasticsearch.yml`. Here is an example:
```yaml
plugins:
  - id: analysis-icu
  - id: repository-azure
  - id: custom-mapper
    location: <EXAMPLE_URL>/archive/custom-mapper-1.0.0.zip
```

This example installs the official `analysis-icu` and `repository-azure` plugins, and one unofficial plugin. Every plugin must provide an `id`. Unofficial plugins must also provide a `location`. This is typically a URL, but Maven coordinates are also supported. The downloaded plugin’s name must match the ID in the configuration file.
While Elasticsearch will respect the [standard Java proxy system properties](https://docs.oracle.com/javase/8/docs/technotes/guides/net/proxies.md) when downloading plugins, you can also configure an HTTP proxy to use explicitly in the configuration file. For example:
```yaml
plugins:
  - id: custom-mapper
    location: <EXAMPLE_URL>/archive/custom-mapper-1.0.0.zip
proxy: proxy.example.com:8443
```