﻿---
title: Installing multiple plugins
description: Multiple plugins can be installed in one invocation as follows: Each plugin_id can be any valid form for installing a single plugin (e.g., the name of...
url: https://www.elastic.co/docs/reference/elasticsearch/plugins/installing-multiple-plugins
products:
  - Elasticsearch
applies_to:
  - Self-managed Elastic deployments: Generally available
---

# Installing multiple plugins
Multiple plugins can be installed in one invocation as follows:
```shell
sudo bin/elasticsearch-plugin install [plugin_id] [plugin_id] ... [plugin_id]
```

Each `plugin_id` can be any valid form for installing a single plugin (e.g., the name of a core plugin, or a custom URL).
For instance, to install the core [ICU plugin](https://www.elastic.co/docs/reference/elasticsearch/plugins/analysis-icu), run the following command:
```shell
sudo bin/elasticsearch-plugin install analysis-icu
```

This command will install the versions of the plugins that matches your Elasticsearch version. The installation will be treated as a transaction, so that all the plugins will be installed, or none of the plugins will be installed if any installation fails.