﻿---
title: Analysis plugins
description: Analysis plugins extend Elasticsearch by adding new analyzers, tokenizers, token filters, or character filters to Elasticsearch. The core analysis plugins...
url: https://www.elastic.co/docs/reference/elasticsearch/plugins/analysis-plugins
products:
  - Elasticsearch
---

# Analysis plugins
Analysis plugins extend Elasticsearch by adding new analyzers, tokenizers, token filters, or character filters to Elasticsearch.

## Core analysis plugins

The core analysis plugins are:
<definitions>
  <definition term="ICU">
    Adds extended Unicode support using the [ICU](http://site.icu-project.org/) libraries, including better analysis of Asian languages, Unicode normalization, Unicode-aware case folding, collation support, and transliteration.
  </definition>
  <definition term="Kuromoji">
    Advanced analysis of Japanese using the [Kuromoji analyzer](https://www.atilika.org/).
  </definition>
  <definition term="Nori">
    Morphological analysis of Korean using the Lucene Nori analyzer.
  </definition>
  <definition term="Phonetic">
    Analyzes tokens into their phonetic equivalent using Soundex, Metaphone, Caverphone, and other codecs.
  </definition>
  <definition term="SmartCN">
    An analyzer for Chinese or mixed Chinese-English text. This analyzer uses probabilistic knowledge to find the optimal word segmentation for Simplified Chinese text. The text is first broken into sentences, then each sentence is segmented into words.
  </definition>
  <definition term="Stempel">
    Provides high quality stemming for Polish.
  </definition>
  <definition term="Ukrainian">
    Provides stemming for Ukrainian.
  </definition>
</definitions>


## Community contributed analysis plugins

A number of analysis plugins have been contributed by our community:
- [IK Analysis Plugin](https://github.com/medcl/elasticsearch-analysis-ik) (by Medcl)
- [Pinyin Analysis Plugin](https://github.com/medcl/elasticsearch-analysis-pinyin) (by Medcl)
- [Vietnamese Analysis Plugin](https://github.com/duydo/elasticsearch-analysis-vietnamese) (by Duy Do)
- [STConvert Analysis Plugin](https://github.com/medcl/elasticsearch-analysis-stconvert) (by Medcl)