﻿---
title: nori_part_of_speech token filter
description: The nori_part_of_speech token filter removes tokens that match a set of part-of-speech tags. The list of supported tags and their meanings can be found...
url: https://www.elastic.co/docs/reference/elasticsearch/plugins/analysis-nori-speech
products:
  - Elasticsearch
---

# nori_part_of_speech token filter
The `nori_part_of_speech` token filter removes tokens that match a set of part-of-speech tags. The list of supported tags and their meanings can be found here: [Part of speech tags](https://lucene.apache.org/core/10_1_0/core/../analysis/nori/org/apache/lucene/analysis/ko/POS.Tag.html)
It accepts the following setting:
<definitions>
  <definition term="stoptags">
    An array of part-of-speech tags that should be removed.
  </definition>
</definitions>

and defaults to:
```js
"stoptags": [
    "E",
    "IC",
    "J",
    "MAG", "MAJ", "MM",
    "SP", "SSC", "SSO", "SC", "SE",
    "XPN", "XSA", "XSN", "XSV",
    "UNA", "NA", "VSV"
]
```

For example:
```json

{
  "settings": {
    "index": {
      "analysis": {
        "analyzer": {
          "my_analyzer": {
            "tokenizer": "nori_tokenizer",
            "filter": [
              "my_posfilter"
            ]
          }
        },
        "filter": {
          "my_posfilter": {
            "type": "nori_part_of_speech",
            "stoptags": [
              "NR"   <1>
            ]
          }
        }
      }
    }
  }
}


{
  "analyzer": "my_analyzer",
  "text": "여섯 용이"  <2>
}
```

Which responds with:
```json
{
  "tokens" : [ {
    "token" : "용",
    "start_offset" : 3,
    "end_offset" : 4,
    "type" : "word",
    "position" : 1
  }, {
    "token" : "이",
    "start_offset" : 4,
    "end_offset" : 5,
    "type" : "word",
    "position" : 2
  } ]
}
```