﻿---
title: nori_readingform token filter
description: The nori_readingform token filter rewrites tokens written in Hanja to their Hangul form. Which responds with: 
url: https://www.elastic.co/docs/reference/elasticsearch/plugins/analysis-nori-readingform
products:
  - Elasticsearch
---

# nori_readingform token filter
The `nori_readingform` token filter rewrites tokens written in Hanja to their Hangul form.
```json

{
  "settings": {
    "index": {
      "analysis": {
        "analyzer": {
          "my_analyzer": {
            "tokenizer": "nori_tokenizer",
            "filter": [ "nori_readingform" ]
          }
        }
      }
    }
  }
}


{
  "analyzer": "my_analyzer",
  "text": "鄕歌"      <1>
}
```

Which responds with:
```json
{
  "tokens" : [ {
    "token" : "향가",     
    "start_offset" : 0,
    "end_offset" : 2,
    "type" : "word",
    "position" : 0
  }]
}
```