﻿---
title: ja_stop token filter
description: The ja_stop token filter filters out Japanese stopwords (_japanese_), and any other custom stopwords specified by the user. This filter only supports...
url: https://www.elastic.co/docs/reference/elasticsearch/plugins/analysis-kuromoji-stop
products:
  - Elasticsearch
---

# ja_stop token filter
The `ja_stop` token filter filters out Japanese stopwords (`_japanese_`), and any other custom stopwords specified by the user. This filter only supports the predefined `_japanese_` stopwords list. If you want to use a different predefined list, then use the [`stop` token filter](https://www.elastic.co/docs/reference/text-analysis/analysis-stop-tokenfilter) instead.
```json

{
  "settings": {
    "index": {
      "analysis": {
        "analyzer": {
          "analyzer_with_ja_stop": {
            "tokenizer": "kuromoji_tokenizer",
            "filter": [
              "ja_stop"
            ]
          }
        },
        "filter": {
          "ja_stop": {
            "type": "ja_stop",
            "stopwords": [
              "_japanese_",
              "ストップ"
            ]
          }
        }
      }
    }
  }
}


{
  "analyzer": "analyzer_with_ja_stop",
  "text": "ストップは消える"
}
```

The above request returns:
```json
{
  "tokens" : [ {
    "token" : "消える",
    "start_offset" : 5,
    "end_offset" : 8,
    "type" : "word",
    "position" : 2
  } ]
}
```