﻿---
title: kuromoji_stemmer token filter
description: The kuromoji_stemmer token filter normalizes common katakana spelling variations ending in a long sound character by removing this character (U+30FC)...
url: https://www.elastic.co/docs/reference/elasticsearch/plugins/analysis-kuromoji-stemmer
products:
  - Elasticsearch
---

# kuromoji_stemmer token filter
The `kuromoji_stemmer` token filter normalizes common katakana spelling variations ending in a long sound character by removing this character (U+30FC). Only full-width katakana characters are supported.
This token filter accepts the following setting:
<definitions>
  <definition term="minimum_length">
    Katakana words shorter than the `minimum length` are not stemmed (default is `4`).
  </definition>
</definitions>

```json

{
  "settings": {
    "index": {
      "analysis": {
        "analyzer": {
          "my_analyzer": {
            "tokenizer": "kuromoji_tokenizer",
            "filter": [
              "my_katakana_stemmer"
            ]
          }
        },
        "filter": {
          "my_katakana_stemmer": {
            "type": "kuromoji_stemmer",
            "minimum_length": 4
          }
        }
      }
    }
  }
}


{
  "analyzer": "my_analyzer",
  "text": "コピー" <1>
}


{
  "analyzer": "my_analyzer",
  "text": "サーバー" <2>
}
```