﻿---
title: katakana_uppercase token filter
description: The katakana_uppercase token filter normalizes small letters (捨て仮名) in katakana into standard letters. This filter is useful if you want to search against...
url: https://www.elastic.co/docs/reference/elasticsearch/plugins/analysis-kuromoji-katakana-uppercase
products:
  - Elasticsearch
---

# katakana_uppercase token filter
The `katakana_uppercase` token filter normalizes small letters (捨て仮名) in katakana into standard letters. This filter is useful if you want to search against old style Japanese text such as patents, legal documents, contract policies, etc.
For example:
```json

{
  "settings": {
    "index": {
      "analysis": {
        "analyzer": {
          "my_analyzer": {
            "tokenizer": "kuromoji_tokenizer",
            "filter": [
              "katakana_uppercase"
            ]
          }
        }
      }
    }
  }
}


{
  "analyzer": "my_analyzer",
  "text": "ストップウォッチ"
}
```

Which results in:
```json
{
  "tokens": [
    {
      "token": "ストツプウオツチ",
      "start_offset": 0,
      "end_offset": 8,
      "type": "word",
      "position": 0
    }
  ]
}
```