﻿---
title: hiragana_uppercase token filter
description: The hiragana_uppercase token filter normalizes small letters (捨て仮名) in hiragana into standard letters. This filter is useful if you want to search against...
url: https://www.elastic.co/docs/reference/elasticsearch/plugins/analysis-kuromoji-hiragana-uppercase
products:
  - Elasticsearch
---

# hiragana_uppercase token filter
The `hiragana_uppercase` token filter normalizes small letters (捨て仮名) in hiragana into standard letters. This filter is useful if you want to search against old style Japanese text such as patents, legal documents, contract policies, etc.
For example:
```json

{
  "settings": {
    "index": {
      "analysis": {
        "analyzer": {
          "my_analyzer": {
            "tokenizer": "kuromoji_tokenizer",
            "filter": [
              "hiragana_uppercase"
            ]
          }
        }
      }
    }
  }
}


{
  "analyzer": "my_analyzer",
  "text": "ちょっとまって"
}
```

Which results in:
```json
{
  "tokens": [
    {
      "token": "ちよつと",
      "start_offset": 0,
      "end_offset": 4,
      "type": "word",
      "position": 0
    },
    {
      "token": "まつ",
      "start_offset": 4,
      "end_offset": 6,
      "type": "word",
      "position": 1
    },
    {
      "token": "て",
      "start_offset": 6,
      "end_offset": 7,
      "type": "word",
      "position": 2
    }
  ]
}
```