﻿---
title: kuromoji_completion token filter
description: The kuromoji_completion token filter adds Japanese romanized tokens to the term attributes along with the original tokens (surface forms). The kuromoji_completion...
url: https://www.elastic.co/docs/reference/elasticsearch/plugins/analysis-kuromoji-completion
products:
  - Elasticsearch
---

# kuromoji_completion token filter
The `kuromoji_completion` token filter adds Japanese romanized tokens to the term attributes along with the original tokens (surface forms).
```json

{
  "analyzer": "kuromoji_completion",
  "text": "寿司" <1>
}
```

The `kuromoji_completion` token filter accepts the following settings:
<definitions>
  <definition term="mode">
    The tokenization mode determines how the tokenizer handles compound and unknown words. It can be set to:
  </definition>
  <definition term="index">
    Simple romanization. Expected to be used when indexing.
  </definition>
  <definition term="query">
    Input Method aware romanization. Expected to be used when querying.
  </definition>
</definitions>

Defaults to `index`.