﻿---
title: kuromoji_baseform token filter
description: The kuromoji_baseform token filter replaces terms with their BaseFormAttribute. This acts as a lemmatizer for verbs and adjectives. Example: which responds...
url: https://www.elastic.co/docs/reference/elasticsearch/plugins/analysis-kuromoji-baseform
products:
  - Elasticsearch
---

# kuromoji_baseform token filter
The `kuromoji_baseform` token filter replaces terms with their BaseFormAttribute. This acts as a lemmatizer for verbs and adjectives. Example:
```json

{
  "settings": {
    "index": {
      "analysis": {
        "analyzer": {
          "my_analyzer": {
            "tokenizer": "kuromoji_tokenizer",
            "filter": [
              "kuromoji_baseform"
            ]
          }
        }
      }
    }
  }
}


{
  "analyzer": "my_analyzer",
  "text": "飲み"
}
```

which responds with:
```json
{
  "tokens" : [ {
    "token" : "飲む",
    "start_offset" : 0,
    "end_offset" : 2,
    "type" : "word",
    "position" : 0
  } ]
}
```