﻿---
title: ICU analysis plugin
description: The ICU Analysis plugin integrates the Lucene ICU module into Elasticsearch, adding extended Unicode support using the ICU libraries, including better...
url: https://www.elastic.co/docs/reference/elasticsearch/plugins/analysis-icu
products:
  - Elasticsearch
---

# ICU analysis plugin
The ICU Analysis plugin integrates the Lucene ICU module into Elasticsearch, adding extended Unicode support using the [ICU](https://icu.unicode.org/) libraries, including better analysis of Asian languages, Unicode normalization, Unicode-aware case folding, collation support, and transliteration.
<admonition title="ICU analysis and backwards compatibility">
  From time to time, the ICU library receives updates such as adding new characters and emojis, and improving collation (sort) orders. These changes may or may not affect search and sort orders, depending on which characters sets you are using.While we restrict ICU upgrades to major versions, you may find that an index created in the previous major version will need to be reindexed in order to return correct (and correctly ordered) results, and to take advantage of new characters.
</admonition>


## Installation

This plugin can be installed using the plugin manager:
```sh
sudo bin/elasticsearch-plugin install analysis-icu
```

The plugin must be installed on every node in the cluster, and each node must be restarted after installation.
You can download this plugin for [offline install](https://www.elastic.co/docs/reference/elasticsearch/plugins/plugin-management-custom-url) from [[https://artifacts.elastic.co/downloads/elasticsearch-plugins/analysis-icu/analysis-icu-9.3.0.zip](https://artifacts.elastic.co/downloads/elasticsearch-plugins/analysis-icu/analysis-icu-9.3.0.zip)](https://artifacts.elastic.co/downloads/elasticsearch-plugins/analysis-icu/analysis-icu-9.3.0.zip). To verify the `.zip` file, use the [SHA hash](https://artifacts.elastic.co/downloads/elasticsearch-plugins/analysis-icu/analysis-icu-9.3.0.zip.sha512) or [ASC key](https://artifacts.elastic.co/downloads/elasticsearch-plugins/analysis-icu/analysis-icu-9.3.0.zip.asc).

## Removal

The plugin can be removed with the following command:
```sh
sudo bin/elasticsearch-plugin remove analysis-icu
```

The node must be stopped before removing the plugin.