﻿---
title: ICU transform token filter
description: Transforms are used to process Unicode text in many different ways, such as case mapping, normalization, transliteration and bidirectional text handling...
url: https://www.elastic.co/docs/reference/elasticsearch/plugins/analysis-icu-transform
products:
  - Elasticsearch
---

# ICU transform token filter
Transforms are used to process Unicode text in many different ways, such as case mapping, normalization, transliteration and bidirectional text handling.
You can define which transformation you want to apply with the `id` parameter (defaults to `Null`), and specify text direction with the `dir` parameter which accepts `forward` (default) for LTR and `reverse` for RTL. Custom rulesets are not yet supported.
For example:
```json

{
  "settings": {
    "index": {
      "analysis": {
        "analyzer": {
          "latin": {
            "tokenizer": "keyword",
            "filter": [
              "myLatinTransform"
            ]
          }
        },
        "filter": {
          "myLatinTransform": {
            "type": "icu_transform",
            "id": "Any-Latin; NFD; [:Nonspacing Mark:] Remove; NFC" <1>
          }
        }
      }
    }
  }
}


{
  "analyzer": "latin",
  "text": "你好" <2>
}


{
  "analyzer": "latin",
  "text": "здравствуйте" <3>
}


{
  "analyzer": "latin",
  "text": "こんにちは" <4>
}
```

For more documentation, Please see the [user guide of ICU Transform](https://unicode-org.github.io/icu/userguide/transforms/).