﻿---
title: ICU normalization token filter
description: Normalizes characters as explained here. It registers itself as the icu_normalizer token filter, which is available to all indices without any further...
url: https://www.elastic.co/docs/reference/elasticsearch/plugins/analysis-icu-normalization
products:
  - Elasticsearch
---

# ICU normalization token filter
Normalizes characters as explained [here](https://unicode-org.github.io/icu/userguide/transforms/normalization/). It registers itself as the `icu_normalizer` token filter, which is available to all indices without any further configuration. The type of normalization can be specified with the `name` parameter, which accepts `nfc`, `nfkc`, and `nfkc_cf` (default).
Which letters are normalized can be controlled by specifying the `unicode_set_filter` parameter, which accepts a [UnicodeSet](https://icu-project.org/apiref/icu4j/com/ibm/icu/text/UnicodeSet.md).
You should probably prefer the [Normalization character filter](https://www.elastic.co/docs/reference/elasticsearch/plugins/analysis-icu-normalization-charfilter).
Here are two examples, the default usage and a customised token filter:
```json

{
  "settings": {
    "index": {
      "analysis": {
        "analyzer": {
          "nfkc_cf_normalized": { <1>
            "tokenizer": "icu_tokenizer",
            "filter": [
              "icu_normalizer"
            ]
          },
          "nfc_normalized": { <2>
            "tokenizer": "icu_tokenizer",
            "filter": [
              "nfc_normalizer"
            ]
          }
        },
        "filter": {
          "nfc_normalizer": {
            "type": "icu_normalizer",
            "name": "nfc"
          }
        }
      }
    }
  }
}
```