﻿---
title: ICU collation keyword field
description: Collations are used for sorting documents in a language-specific word order. The icu_collation_keyword field type is available to all indices and will...
url: https://www.elastic.co/docs/reference/elasticsearch/plugins/analysis-icu-collation-keyword-field
products:
  - Elasticsearch
---

# ICU collation keyword field
Collations are used for sorting documents in a language-specific word order. The `icu_collation_keyword` field type is available to all indices and will encode the terms directly as bytes in a doc values field and a single indexed token just like a standard [Keyword Field](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/keyword).
Defaults to using [DUCET collation](https://www.elastic.co/guide/en/elasticsearch/guide/2.x/sorting-collations.html#uca), which is a best-effort attempt at language-neutral sorting.
Below is an example of how to set up a field for sorting German names in phonebook order:
```json

{
  "mappings": {
    "properties": {
      "name": {   <1>
        "type": "text",
        "fields": {
          "sort": {  <2>
            "type": "icu_collation_keyword",
            "index": false,
            "language": "de",
            "country": "DE",
            "variant": "@collation=phonebook"
          }
        }
      }
    }
  }
}


{
  "query": {
    "match": {
      "name": "Fritz"
    }
  },
  "sort": "name.sort"
}
```


## Parameters for ICU collation keyword fields

The following parameters are accepted by `icu_collation_keyword` fields:
<definitions>
  <definition term="doc_values">
    Should the field be stored on disk in a column-stride fashion, so that it can later be used for sorting, aggregations, or scripting? Accepts `true` (default) or `false`.
  </definition>
  <definition term="index">
    Should the field be searchable? Accepts `true` (default) or `false`.
  </definition>
  <definition term="null_value">
    Accepts a string value which is substituted for any explicit `null` values. Defaults to `null`, which means the field is treated as missing.
  </definition>
  <definition term="ignore_above">
    Strings longer than the `ignore_above` setting will be ignored. Checking is performed on the original string before the collation. The `ignore_above` setting can be updated on existing fields using the [PUT mapping API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-put-mapping). By default, there is no limit and all values will be indexed.
  </definition>
  <definition term="store">
    Whether the field value should be stored and retrievable separately from the [`_source`](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/mapping-source-field) field. Accepts `true` or `false` (default).
  </definition>
  <definition term="fields">
    Multi-fields allow the same string value to be indexed in multiple ways for different purposes, such as one field for search and a multi-field for sorting and aggregations.
  </definition>
</definitions>


## Collation options

<definitions>
  <definition term="strength">
    The strength property determines the minimum level of difference considered significant during comparison. Possible values are : `primary`, `secondary`, `tertiary`, `quaternary` or `identical`. See the [ICU Collation documentation](https://icu-project.org/apiref/icu4j/com/ibm/icu/text/Collator.md) for a more detailed explanation for each value. Defaults to `tertiary` unless otherwise specified in the collation.
  </definition>
  <definition term="decomposition">
    Possible values: `no` (default, but collation-dependent) or `canonical`. Setting this decomposition property to `canonical` allows the Collator to handle unnormalized text properly, producing the same results as if the text were normalized. If `no` is set, it is the user’s responsibility to ensure that all text is already in the appropriate form before a comparison or before getting a CollationKey. Adjusting decomposition mode allows the user to select between faster and more complete collation behavior. Since a great many of the world’s languages do not require text normalization, most locales set `no` as the default decomposition mode.
  </definition>
</definitions>

The following options are expert only:
<definitions>
  <definition term="alternate">
    Possible values: `shifted` or `non-ignorable`. Sets the alternate handling for strength `quaternary` to be either shifted or non-ignorable. Which boils down to ignoring punctuation and whitespace.
  </definition>
  <definition term="case_level">
    Possible values: `true` or `false` (default). Whether case level sorting is required. When strength is set to `primary` this will ignore accent differences.
  </definition>
  <definition term="case_first">
    Possible values: `lower` or `upper`. Useful to control which case is sorted first when the case is not ignored for strength `tertiary`. The default depends on the collation.
  </definition>
  <definition term="numeric">
    Possible values: `true` or `false` (default) . Whether digits are sorted according to their numeric representation. For example the value `egg-9` is sorted before the value `egg-21`.
  </definition>
  <definition term="variable_top">
    Single character or contraction. Controls what is variable for `alternate`.
  </definition>
  <definition term="hiragana_quaternary_mode">
    Possible values: `true` or `false`. Distinguishing between Katakana and Hiragana characters in `quaternary` strength.
  </definition>
</definitions>