﻿---
title: Reimplementing and extending the polish analyzer
description: The polish analyzer could be reimplemented as a custom analyzer that can then be extended and configured differently as follows: 
url: https://www.elastic.co/docs/reference/elasticsearch/plugins/_reimplementing_and_extending_the_analyzers_2
products:
  - Elasticsearch
---

# Reimplementing and extending the polish analyzer
The `polish` analyzer could be reimplemented as a `custom` analyzer that can then be extended and configured differently as follows:
```json

{
  "settings": {
    "analysis": {
      "analyzer": {
        "rebuilt_stempel": {
          "tokenizer":  "standard",
          "filter": [
            "lowercase",
            "polish_stop",
            "polish_stem"
          ]
        }
      }
    }
  }
}
```