﻿---
title: Reimplementing and extending the smartcn analyzer
description: The smartcn analyzer could be reimplemented as a custom analyzer that can then be extended and configured as follows: 
url: https://www.elastic.co/docs/reference/elasticsearch/plugins/_reimplementing_and_extending_the_analyzers
products:
  - Elasticsearch
---

# Reimplementing and extending the smartcn analyzer
The `smartcn` analyzer could be reimplemented as a `custom` analyzer that can then be extended and configured as follows:
```json

{
  "settings": {
    "analysis": {
      "analyzer": {
        "rebuilt_smartcn": {
          "tokenizer":  "smartcn_tokenizer",
          "filter": [
            "porter_stem",
            "smartcn_stop"
          ]
        }
      }
    }
  }
}
```