﻿---
title: Token count field type
description: A field of type token_count is really an integer field which accepts string values, analyzes them, then indexes the number of tokens in the string. For...
url: https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/token-count
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Token count field type
A field of type `token_count` is really an [`integer`](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/number) field which accepts string values, analyzes them, then indexes the number of tokens in the string.
For instance:
```json

{
  "mappings": {
    "properties": {
      "name": { <1>
        "type": "text",
        "fields": {
          "length": { <2>
            "type":     "token_count",
            "analyzer": "standard"
          }
        }
      }
    }
  }
}


{ "name": "John Smith" }


{ "name": "Rachel Alice Williams" }


{
  "query": {
    "term": {
      "name.length": 3 <3>
    }
  }
}
```


## Parameters for `token_count` fields

The following parameters are accepted by `token_count` fields:
<definitions>
  <definition term="analyzer">
    The [analyzer](https://www.elastic.co/docs/manage-data/data-store/text-analysis) which should be used to analyze the string value. Required. For best performance, use an analyzer without token filters.
  </definition>
  <definition term="enable_position_increments">
    Indicates if position increments should be counted. Set to `false` if you don’t want to count tokens removed by analyzer filters (like [`stop`](https://www.elastic.co/docs/reference/text-analysis/analysis-stop-tokenfilter)). Defaults to `true`.
  </definition>
  <definition term="doc_values">
    Should the field be stored on disk in a column-stride fashion, so that it can later be used for sorting, aggregations, or scripting? Accepts `true` (default) or `false`.
  </definition>
  <definition term="index">
    Should the field be searchable? Accepts `true` (default) and `false`.
  </definition>
  <definition term="null_value">
    Accepts a numeric value of the same `type` as the field which is substituted for any explicit `null` values. Defaults to `null`, which means the field is treated as missing.
  </definition>
  <definition term="store">
    Whether the field value should be stored and retrievable separately from the [`_source`](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/mapping-source-field) field. Accepts `true` or `false` (default).
  </definition>
</definitions>


### Synthetic `_source`

`token_count` fields support [synthetic `_source`](/docs/reference/elasticsearch/mapping-reference/mapping-source-field#synthetic-source) in their default configuration.