﻿---
title: term_vector
description: Term vectors contain information about the terms produced by the analysis process, including: a list of terms.the position (or order) of each term.the...
url: https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/term-vector
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# term_vector
Term vectors contain information about the terms produced by the [analysis](https://www.elastic.co/docs/manage-data/data-store/text-analysis) process, including:
- a list of terms.
- the position (or order) of each term.
- the start and end character offsets mapping the term to its origin in the original string.
- payloads (if they are available) — user-defined binary data associated with each term position.

These term vectors can be stored so that they can be retrieved for a particular document.
Refer to the [term vectors API examples](https://www.elastic.co/docs/reference/elasticsearch/rest-apis/term-vectors-examples) page for usage examples.
The `term_vector` setting accepts:
<definitions>
  <definition term="no">
    No term vectors are stored. (default)
  </definition>
  <definition term="yes">
    Just the terms in the field are stored.
  </definition>
  <definition term="with_positions">
    Terms and positions are stored.
  </definition>
  <definition term="with_offsets">
    Terms and character offsets are stored.
  </definition>
  <definition term="with_positions_offsets">
    Terms, positions, and character offsets are stored.
  </definition>
  <definition term="with_positions_payloads">
    Terms, positions, and payloads are stored.
  </definition>
  <definition term="with_positions_offsets_payloads">
    Terms, positions, offsets and payloads are stored.
  </definition>
</definitions>

The fast vector highlighter requires `with_positions_offsets`. [The term vectors API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-termvectors) can retrieve whatever is stored.
<warning>
  Setting `with_positions_offsets` will double the size of a field’s index.
</warning>

```json

{
  "mappings": {
    "properties": {
      "text": {
        "type":        "text",
        "term_vector": "with_positions_offsets"
      }
    }
  }
}


{
  "text": "Quick brown fox"
}


{
  "query": {
    "match": {
      "text": "brown fox"
    }
  },
  "highlight": {
    "fields": {
      "text": {} <1>
    }
  }
}
```