﻿---
title: subobjects
description: When indexing a document or updating mappings, Elasticsearch accepts fields that contain dots in their names, which get expanded to their corresponding...
url: https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/subobjects
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# subobjects
When indexing a document or updating mappings, Elasticsearch accepts fields that contain dots in their names, which get expanded to their corresponding object structure. For instance, the  field `metrics.time.max` is mapped as a `max` leaf field with a parent `time` object, belonging to its parent `metrics` object.
The described default behaviour is reasonable for most scenarios, but causes problems in certain situations where for instance a field `metrics.time` holds a value too, which is common when indexing metrics data. A document holding a value for both `metrics.time.max` and `metrics.time` gets rejected given that `time` would need to be a leaf field to hold a value as well as an object to hold the `max` sub-field.
The `subobjects` setting, which can be applied only to the top-level mapping definition and to [`object`](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/object) fields, disables the ability for an object to hold further subobjects and makes it possible to store documents where field names contain dots and share common prefixes. From the example above, if the object container `metrics` has `subobjects` set to `false`, it can hold values for both `time` and `time.max` directly without the need for any intermediate object, as dots in field names are preserved.
```json

{
  "mappings": {
    "properties": {
      "metrics": {
        "type":  "object",
        "subobjects": false, <1>
        "properties": {
          "time": { "type": "long" },
          "time.min": { "type": "long" },
          "time.max": { "type": "long" }
        }
      }
    }
  }
}


{
  "metrics.time" : 100, <2>
  "metrics.time.min" : 10,
  "metrics.time.max" : 900
}


{
  "metrics" : {
    "time" : 100, <3>
    "time.min" : 10,
    "time.max" : 900
  }
}
```

```json
{
  "my-index-000001" : {
    "mappings" : {
      "properties" : {
        "metrics" : {
          "subobjects" : false,
          "properties" : {
            "time" : {
              "type" : "long"
            },
            "time.min" : { 
              "type" : "long"
            },
            "time.max" : {
              "type" : "long"
            }
          }
        }
      }
    }
  }
}
```

The entire mapping may be configured to not support subobjects as well, in which case the document can only ever hold leaf sub-fields:
```json

{
  "mappings": {
    "subobjects": false <1>
  }
}


{
  "time" : "100ms", <2>
  "time.min" : "10ms",
  "time.max" : "900ms"
}
```

The `subobjects` setting for existing fields and the top-level mapping definition cannot be updated.

## Auto-flattening object mappings

<warning>
  Object fields of type `nested` don't work when wrapped by an object field that is configured with `subobjects: false`.
</warning>

It is generally recommended to define the properties of an object that is configured with `subobjects: false` with dotted field names (as shown in the first example). However, it is also possible to define these properties as sub-objects in the mappings. In that case, the mapping will be automatically flattened before it is stored. This makes it easier to re-use existing mappings without having to re-write them.
Note that auto-flattening will not work when certain [mapping parameters](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/mapping-parameters) are set on object mappings that are defined under an object configured with `subobjects: false`:
- The [`enabled`](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/enabled) mapping parameter must not be `false`.
- The [`dynamic`](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/dynamic) mapping parameter must not contradict the implicit or explicit value of the parent. For example, when `dynamic` is set to `false` in the root of the mapping, object mappers that set `dynamic` to `true` can’t be auto-flattened.
- The `subobjects` mapping parameter must not be set to `true` explicitly.

```json

{
  "mappings": {
    "properties": {
      "metrics": {
        "subobjects": false,
        "properties": {
          "time": {
            "type": "object", <1>
            "properties": {
              "min": { "type": "long" }, <2>
              "max": { "type": "long" }
            }
          }
        }
      }
    }
  }
}
```

```json
{
  "my-index-000002" : {
    "mappings" : {
      "properties" : {
        "metrics" : {
          "subobjects" : false,
          "properties" : {
            "time.min" : { 
              "type" : "long"
            },
            "time.max" : {
              "type" : "long"
            }
          }
        }
      }
    }
  }
}
```