﻿---
title: similarity
description: Elasticsearch allows you to configure a text scoring algorithm or similarity per field. The similarity setting provides a simple way of choosing a text...
url: https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/similarity
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# similarity
Elasticsearch allows you to configure a text scoring algorithm or *similarity* per field. The `similarity` setting provides a simple way of choosing a text similarity algorithm other than the default `BM25`, such as `boolean`.
Only text-based field types like [`text`](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/text) and [`keyword`](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/keyword) support this configuration.
Custom similarities can be configured by tuning the parameters of the built-in similarities. For more details about this expert options, see the [similarity module](https://www.elastic.co/docs/reference/elasticsearch/index-settings/similarity).
The only similarities which can be used out of the box, without any further configuration are:
<definitions>
  <definition term="BM25">
    The [Okapi BM25 algorithm](https://en.wikipedia.org/wiki/Okapi_BM25). The algorithm used by default in Elasticsearch and Lucene.
  </definition>
  <definition term="boolean">
    A simple boolean similarity, which is used when full-text ranking is not needed and the score should only be based on whether the query terms match or not. Boolean similarity gives terms a score equal to their query boost.
  </definition>
</definitions>

The `similarity` can be set on the field level when a field is first created, as follows:
```json

{
  "mappings": {
    "properties": {
      "default_field": { <1>
        "type": "text"
      },
      "boolean_sim_field": {
        "type": "text",
        "similarity": "boolean" <2>
      }
    }
  }
}
```