﻿---
title: Semantic text field type
description: The semantic_text field type simplifies semantic search by providing sensible defaults that automate most of the manual work typically required for vector...
url: https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/semantic-text
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available since 9.0
---

# Semantic text field type
The `semantic_text` field type simplifies [semantic search](https://www.elastic.co/docs/solutions/search/semantic-search) by providing sensible defaults that automate most of the manual work typically required for vector search. Using `semantic_text`, you don't have to manually configure mappings, set up ingestion pipelines, or handle chunking. The field type automatically:
- Configures index mappings: Chooses the correct field type (`sparse_vector` or `dense_vector`), dimensions, similarity functions, and storage optimizations based on the inference endpoint.
- Generates embeddings during indexing: Automatically generates embeddings when you index documents, without requiring ingestion pipelines or inference processors.
- Handles chunking: Automatically chunks long text documents during indexing.


## Basic `semantic_text` mapping example

The following example creates an index mapping with a `semantic_text` field:
```json

{
  "mappings": { 
    "properties": {
      "content": { 
        "type": "semantic_text" <1>
      }
    }
  }
}
```

<tip>
  For a complete example, refer to the [Semantic search with `semantic_text`](https://www.elastic.co/docs/solutions/search/semantic-search/semantic-search-semantic-text) tutorial.
</tip>


## Overview

The `semantic_text` field type documentation is organized into reference content and how-to guides.

### Reference

The [Reference](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/semantic-text-reference) section provides technical reference content:
- [Parameters](/docs/reference/elasticsearch/mapping-reference/semantic-text-reference#semantic-text-params): Parameter descriptions for `semantic_text` fields.
- [Inference endpoints](/docs/reference/elasticsearch/mapping-reference/semantic-text-reference#configuring-inference-endpoints): Overview of inference endpoints used with `semantic_text` fields.
- [Chunking](/docs/reference/elasticsearch/mapping-reference/semantic-text-reference#chunking-behavior): How `semantic_text` automatically processes long text passages by generating smaller chunks.
- [Pre-filtering for dense vector queries](/docs/reference/elasticsearch/mapping-reference/semantic-text-reference#pre-filtering-for-dense-vector-queries): Automatic pre-filtering behavior for dense vector queries on `semantic_text` fields.
- [Limitations](/docs/reference/elasticsearch/mapping-reference/semantic-text-reference#limitations): Current limitations of `semantic_text` fields.
- [Document count discrepancy](/docs/reference/elasticsearch/mapping-reference/semantic-text-reference#document-count-discrepancy): Understanding document counts in `_cat/indices` for indices with `semantic_text` fields.
- [Querying `semantic_text` fields](/docs/reference/elasticsearch/mapping-reference/semantic-text-search-retrieval#querying-semantic-text-fields): Supported query types for `semantic_text` fields.


### How-to guides

The [How-to guides](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/semantic-text-how-tos) section organizes procedure descriptions and examples into the following guides:
- [Set up and configure `semantic_text` fields](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/semantic-text-setup-configuration): Learn how to configure inference endpoints, including default and preconfigured options, ELSER on EIS, custom endpoints, and dedicated endpoints for ingestion and search operations.
- [Ingest data with `semantic_text` fields](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/semantic-text-ingestions): Learn how to index pre-chunked content, use `copy_to` and multi-fields to collect values from multiple fields, and perform updates and partial updates to optimize ingestion costs.
- [Search and retrieve `semantic_text` fields](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/semantic-text-search-retrieval): Learn how to query `semantic_text` fields, retrieve indexed chunks, return field embeddings, and highlight the most relevant fragments from search results.