﻿---
title: Set up and configure semantic_text fields
description: This page provides instructions for setting up and configuring semantic_text fields. Learn how to configure inference endpoints, including default and...
url: https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/semantic-text-setup-configuration
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available since 9.0
---

# Set up and configure semantic_text fields
This page provides instructions for setting up and configuring `semantic_text` fields. Learn how to configure inference endpoints, including default and preconfigured options, ELSER on EIS, custom endpoints, and dedicated endpoints for ingestion and search operations.

## Configure inference endpoints

You can configure inference endpoints for `semantic_text` fields in the following ways:
- [Use ELSER on EIS](#using-elser-on-eis)
- [Use default and preconfigured endpoints](#default-and-preconfigured-endpoints)
- [Use a custom inference endpoint](#using-custom-endpoint)

<note>
  If you use a [custom inference endpoint](#using-custom-endpoint) through your ML node and not through Elastic Inference Service (EIS), the recommended method is to [use dedicated endpoints for ingestion and search](#dedicated-endpoints-for-ingestion-and-search).<applies-to>Elastic Stack: Generally available since 9.1</applies-to> If you use EIS, you don't have to set up dedicated endpoints.
</note>


### Use default and preconfigured endpoints

This section shows you how to set up `semantic_text` with different default and preconfigured endpoints.
<tab-set>
  <tab-item title="Default ELSER on EIS on Serverless">
    <applies-to>
      - Elastic Cloud Serverless: Generally available
    </applies-to>
    To use the default `.elser-v2-elastic` endpoint that runs on [EIS](https://www.elastic.co/docs/explore-analyze/elastic-inference/eis#elser-on-eis), you can set up `semantic_text` with the following API request:
    ```json

    {
      "mappings": {
        "properties": {
          "inference_field": {
            "type": "semantic_text"
          }
        }
      }
    }
    ```
    If you don't specify an inference endpoint, the `inference_id` field defaults to
    `.elser-v2-elastic`, a preconfigured endpoint for the `elasticsearch` service.
  </tab-item>

  <tab-item title="Preconfigured ELSER on EIS in Cloud">
    <applies-to>
      - Elastic Stack: Generally available since 9.2
      - Self-managed Elastic deployments: Unavailable
    </applies-to>
    To use the preconfigured `.elser-v2-elastic` endpoint that runs on [EIS](https://www.elastic.co/docs/explore-analyze/elastic-inference/eis#elser-on-eis), you can set up `semantic_text` with the following API request:
    ```json

    {
      "mappings": {
        "properties": {
          "inference_field": {
            "type": "semantic_text",
            "inference_id": ".elser-v2-elastic"
          }
        }
      }
    }
    ```
    If you don't specify an inference endpoint, the `inference_id` field defaults to
    `.elser-2-elasticsearch`, a preconfigured endpoint for the `elasticsearch` service.
  </tab-item>

  <tab-item title="Default ELSER">
    If you use the default `.elser-2-elasticsearch` endpoint, you can set up `semantic_text` with the following API request:
    ```json

    {
      "mappings": {
        "properties": {
          "inference_field": {
            "type": "semantic_text"
          }
        }
      }
    }
    ```
  </tab-item>
</tab-set>


### Use ELSER on EIS

<applies-to>
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available since 9.2
  - Elastic Stack: Preview in 9.1
  - Self-managed Elastic deployments: Unavailable
</applies-to>

If you use the preconfigured `.elser-2-elastic` endpoint that utilizes the ELSER model as a service through the Elastic Inference Service ([ELSER on EIS](https://www.elastic.co/docs/explore-analyze/elastic-inference/eis#elser-on-eis)), you can
set up `semantic_text` with the following API request:
<tab-set>
  <tab-item title="Using ELSER on EIS on Serverless">
    <applies-to>
      - Elastic Cloud Serverless: Generally available
    </applies-to>

    ```json

    {
      "mappings": {
        "properties": {
          "inference_field": {
            "type": "semantic_text"
          }
        }
      }
    }
    ```
  </tab-item>

  <tab-item title="Using ELSER on EIS in Cloud">
    <applies-to>
      - Elastic Stack: Generally available since 9.2
      - Self-managed Elastic deployments: Unavailable
    </applies-to>

    ```json

    {
      "mappings": {
        "properties": {
          "inference_field": {
            "type": "semantic_text",
            "inference_id": ".elser-2-elastic"
          }
        }
      }
    }
    ```
  </tab-item>
</tab-set>


### Use a custom inference endpoint

To use a custom inference endpoint instead of the default endpoint, you
must [Create inference API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-inference-put)
and specify its `inference_id` when setting up the `semantic_text` field type.
```json

{
  "mappings": {
    "properties": {
      "inference_field": {
        "type": "semantic_text",
        "inference_id": "my-openai-endpoint" <1>
      }
    }
  }
}
```


### Use dedicated endpoints for ingestion and search

If you use a [custom inference endpoint](#using-custom-endpoint) through your ML node and not through Elastic Inference Service, the recommended way to use `semantic_text` is by having dedicated inference endpoints for ingestion and search.
This ensures that search speed remains unaffected by ingestion workloads, and vice versa. After creating dedicated inference endpoints for both, you can reference them using the `inference_id`
and `search_inference_id` parameters when setting up the index mapping for an index that uses the `semantic_text` field.
```json

{
  "mappings": {
    "properties": {
      "inference_field": {
        "type": "semantic_text",
        "inference_id": "my-elser-endpoint-for-ingest",
        "search_inference_id": "my-elser-endpoint-for-search"
      }
    }
  }
}
```