﻿---
title: Search and retrieve semantic_text fields
description: This page provides instructions for searching and retrieving data from semantic_text fields. Learn how to query semantic_text fields, retrieve indexed...
url: https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/semantic-text-search-retrieval
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available since 9.0
---

# Search and retrieve semantic_text fields
This page provides instructions for searching and retrieving data from `semantic_text` fields. Learn how to query `semantic_text` fields, retrieve indexed chunks, retrieve field embeddings, and highlight the most relevant fragments from search results.

## Query `semantic_text` fields

You can query `semantic_text` fields using the following query types:
- Match query: The recommended method for querying `semantic_text` fields. You can use [Query DSL](https://www.elastic.co/docs/reference/query-languages/query-dsl/query-dsl-match-query) or [ES|QL](/docs/reference/query-languages/esql/functions-operators/search-functions#esql-match) syntax. To learn how to run match queries on `semantic_text` fields, refer to this [example](https://www.elastic.co/docs/solutions/search/semantic-search/semantic-search-semantic-text#semantic-text-semantic-search).
- kNN query: Finds the nearest vectors to a query vector using a similarity metric, mainly for advanced or combined search use cases. You can use [Query DSL](/docs/reference/query-languages/query-dsl/query-dsl-knn-query#knn-query-with-semantic-text) or <applies-to>Elastic Stack: Generally available since 9.2</applies-to> [ES|QL](/docs/reference/query-languages/esql/functions-operators/dense-vector-functions#esql-knn) syntax. To learn how to run knn queries on `semantic_text` fields, refer to this [example](/docs/reference/query-languages/query-dsl/query-dsl-knn-query#knn-query-with-semantic-text).
- Sparse vector query: Executes searches using sparse vectors generated by a sparse retrieval model such as [ELSER](https://www.elastic.co/docs/explore-analyze/machine-learning/nlp/ml-nlp-elser). You can use it with [Query DSL](https://www.elastic.co/docs/reference/query-languages/query-dsl/query-dsl-sparse-vector-query) syntax. To learn how to run sparse vector queries on `semantic_text` fields, refer to this [example](/docs/reference/query-languages/query-dsl/query-dsl-sparse-vector-query#example-query-on-a-semantic_text-field).
- [Semantic query](https://www.elastic.co/docs/reference/query-languages/query-dsl/query-dsl-semantic-query): We don't recommend this legacy query type for _new_ projects, because the alternatives in this list enable more flexibility and customization. The `semantic` query remains available to support existing implementations.


### Retrieve indexed chunks

<applies-to>
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available since 9.2
</applies-to>

You can retrieve the individual chunks generated by your semantic field's chunking
strategy using the [fields parameter](/docs/reference/elasticsearch/rest-apis/retrieve-selected-fields#search-fields-param):
```json

{
  "query": {
    "ids" : {
      "values" : ["1"]
    }
  },
  "fields": [
    {
      "field": "semantic_text_field",
      "format": "chunks"      <1>
    }
  ]
}
```


## Retrieve `semantic_text` field embeddings

By default, embeddings generated for `semantic_text` fields are stored internally and not included in the response when retrieving documents. Retrieving embeddings is useful when you want to:
- Reindex documents into another index with the same `inference_id` without re-running inference
- Export or migrate documents while preserving their embeddings
- Inspect or debug the raw embeddings generated for your content

The method for retrieving embeddings depends on your Elasticsearch version:
- If you use Elasticsearch 9.2 and later, or Serverless, use the [`_source.exclude_vectors`](#returning-semantic-field-embeddings-in-_source) parameter to include embeddings in `_source`.
- If you use Elasticsearch versions earlier than 9.2, use the [`fields` parameter](#returning-semantic-field-embeddings-using-fields) with `_inference_fields` to retrieve embeddings.


### Include embeddings in `_source`

<applies-to>
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available since 9.2
</applies-to>

To include the full inference fields, including their embeddings, in `_source`, set the `_source.exclude_vectors` option to `false`:
```json

{
  "_source": {
    "exclude_vectors": false
  },
  "query": {
    "match_all": {}
  }
}
```

The embeddings will appear under `_inference_fields` in `_source`.
This works with the
[Get](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-get),
[Search](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-search),
and
[Reindex](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-reindex)
APIs.

#### Example: Reindex while preserving embeddings

<applies-to>
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available since 9.2
</applies-to>

When reindexing documents with `semantic_text` fields, you can preserve existing embeddings by including them in the source documents. This allows documents to be re-indexed without triggering inference again.
<warning>
  The target index's `semantic_text` field must use the same `inference_id` as the source index to reuse existing embeddings. If the `inference_id` values do not match, the documents will fail the reindex task.
</warning>

```json

{
  "source": {
    "index": "my-index-src",
    "_source": {
      "exclude_vectors": false            <1>
    }
  },
  "dest": {
    "index": "my-index-dest"
  }
}
```


#### Example: Troubleshoot `semantic_text` fields

<applies-to>
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available since 9.2
</applies-to>

To verify that your embeddings look correct or debug embedding generation, retrieve the stored embeddings:
```json

{
  "_source": {
    "exclude_vectors": false
  },
  "query": {
    "match": {
      "my_semantic_field": "Which country is Paris in?"
    }
  }
}
```

This will return verbose chunked embeddings content that is used to perform
semantic search for `semantic_text` fields:
```json
{
  "took": 18,
  "timed_out": false,
  "_shards": {
    "total": 1,
    "successful": 1,
    "skipped": 0,
    "failed": 0
  },
  "hits": {
    "total": { "value": 1, "relation": "eq" },
    "max_score": 16.532316,
    "hits": [
      {
        "_index": "test-index",
        "_id": "1",
        "_score": 16.532316,
        "_source": {
          "my_semantic_field": "Paris is the capital of France.",
          "_inference_fields": {
            "my_semantic_field": {
              "inference": {
                "inference_id": ".elser-2-elasticsearch", 
                "model_settings": { 
                  "service": "elasticsearch",
                  "task_type": "sparse_embedding"
                },
                "chunks": {
                  "my_semantic_field": [
                    {
                      "start_offset": 0,
                      "end_offset": 31,
                      "embeddings": { 
                        "airport": 0.12011719,
                        "brussels": 0.032836914,
                        "capital": 2.1328125,
                        "capitals": 0.6386719,
                        "capitol": 1.2890625,
                        "cities": 0.78125,
                        "city": 1.265625,
                        "continent": 0.26953125,
                        "country": 0.59765625,
                        ...
                      }
                    }
                  ]
                }
              }
            }
          }
        }
      }
    ]
  }
}
```


### Retrieve embeddings using `fields`

<important>
  This method for returning semantic field embeddings is recommended only for Elasticsearch versions earlier than 9.2.
  For version 9.2 and later, use the [`exclude_vectors`](#returning-semantic-field-embeddings-in-_source) parameter instead.
</important>

To retrieve stored embeddings, use the `fields` parameter with `_inference_fields`. This lets you include the vector data that is not shown by default in the response.
```json

{
  "query": {
    "match": {
      "my_semantic_field": "Which country is Paris in?"
    }
  },
  "fields": [
    "_inference_fields"
  ]
}
```

The `fields` parameter works with the [Search](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-search) API.

## Highlight the most relevant fragments

Extract the most relevant fragments from a `semantic_text` field using the [highlight parameter](https://www.elastic.co/docs/reference/elasticsearch/rest-apis/highlighting) in the [Search API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-search).
<stepper>
  <step title="Highlight semantic_text fields">
    Use the highlight parameter with `number_of_fragments` and `order` to control fragment selection and sorting:
    ```json

    {
        "query": {
            "match": {
                "my_semantic_field": "Which country is Paris in?"
            }
        },
        "highlight": {
            "fields": {
                "my_semantic_field": {
                    "number_of_fragments": 2,  <1>
                    "order": "score"           <2>
                }
            }
        }
    }
    ```
  </step>

  <step title="Enforce semantic highlighter">
    To restrict highlighting to the semantic highlighter and return no fragments when the field is not of type `semantic_text`, explicitly set the highlighter type to `semantic`:
    ```json

    {
        "query": {
            "match": {
                "my_field": "Which country is Paris in?"
            }
        },
        "highlight": {
            "fields": {
                "my_field": {
                    "type": "semantic",         <1>
                    "number_of_fragments": 2,
                    "order": "score"
                }
            }
        }
    }
    ```
  </step>

  <step title="Retrieve fragments in original order">
    To retrieve all fragments from the semantic highlighter in their original indexing order without scoring, use a `match_all` query as the `highlight_query`:
    ```json

    {
      "query": {
        "ids": {
          "values": ["1"]
        }
      },
      "highlight": {
        "fields": {
          "my_semantic_field": {
            "number_of_fragments": 5,        <1>
            "highlight_query": { "match_all": {} }
          }
        }
      }
    }
    ```
  </step>
</stepper>


## Performing cross-cluster search (CCS) with `semantic_text`

<applies-to>
  - Elastic Cloud Serverless: Unavailable
  - Elastic Stack: Generally available since 9.2
</applies-to>

<applies-switch>
  <applies-item title="stack: ga 9.3+" applies-to="Elastic Stack: Generally available since 9.3">
    `semantic_text` supports [cross-cluster search (CCS)](https://www.elastic.co/docs/explore-analyze/cross-cluster-search) through:
    - The [`_search` endpoint](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-search) when [`ccs_minimize_roundtrips`](https://www.elastic.co/docs/explore-analyze/cross-cluster-search#ccs-network-delays) is `true` or `false`.
    - [Retrievers](https://www.elastic.co/docs/reference/elasticsearch/rest-apis/retrievers)
    - [ES|QL](https://www.elastic.co/docs/reference/query-languages/esql)
    Query `semantic_text` fields across clusters using the standard `_search` endpoint with cluster notation:
    ```json

    {
      "query": {
        "match": {
          "my_semantic_field": "Which country is Paris in?"
        }
      }
    }
    ```
    The same notation can be used to query `semantic_text` fields across clusters with ESQL:
    ```json

    {
        "query": """FROM local-index,remote-cluster:remote-index METADATA _score | <1>
         WHERE MATCH(my_semantic_field, "Which country is Paris in?") |
         SORT _score DESC |
         KEEP my_semantic_field | LIMIT 10
        """
    }
    ```
  </applies-item>

  <applies-item title="stack: ga =9.2" applies-to="Elastic Stack: Generally available in 9.2">
    `semantic_text` supports [cross-cluster search (CCS)](https://www.elastic.co/docs/explore-analyze/cross-cluster-search) through the [`_search` endpoint](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-search) when [`ccs_minimize_roundtrips`](https://www.elastic.co/docs/explore-analyze/cross-cluster-search#ccs-network-delays) is set to `true`.
    This is the default value, so most CCS queries work automatically.CCS is **not** supported in [retrievers](https://www.elastic.co/docs/reference/elasticsearch/rest-apis/retrievers) or [ES|QL](https://www.elastic.co/docs/reference/query-languages/esql).Query `semantic_text` fields across clusters using the standard `_search` endpoint with cluster notation:
    ```json

    {
      "query": {
        "match": {
          "my_semantic_field": "Which country is Paris in?"
        }
      }
    }
    ```
  </applies-item>
</applies-switch>