﻿---
title: How-to guides for the semantic_text field type
description: These guides provide procedure descriptions and examples for common tasks when working with semantic_text fields: Set up and configure semantic_text fields:...
url: https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/semantic-text-how-tos
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available since 9.0
---

# How-to guides for the semantic_text field type
These guides provide procedure descriptions and examples for common tasks when working with `semantic_text` fields:
- [Set up and configure `semantic_text` fields](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/semantic-text-setup-configuration): Learn how to configure inference endpoints, including default and preconfigured options, ELSER on EIS, custom endpoints, and dedicated endpoints for ingestion and search operations.
- [Ingest data with `semantic_text` fields](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/semantic-text-ingestions): Learn how to index pre-chunked content, use `copy_to` and multi-fields to collect values from multiple fields, and perform updates and partial updates to optimize ingestion costs.
- [Search and retrieve `semantic_text` fields](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/semantic-text-search-retrieval): Learn how to query `semantic_text` fields, retrieve indexed chunks, return field embeddings, and highlight the most relevant fragments from search results.