﻿---
title: Rank features field type
description: A rank_features field can index numeric feature vectors, so that they can later be used to boost documents in queries with a rank_feature query. It is...
url: https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/rank-features
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Rank features field type
A `rank_features` field can index numeric feature vectors, so that they can later be used to boost documents in queries with a [`rank_feature`](https://www.elastic.co/docs/reference/query-languages/query-dsl/query-dsl-rank-feature-query) query.
It is analogous to the [`rank_feature`](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/rank-feature) data type but is better suited when the list of features is sparse so that it wouldn’t be reasonable to add one field to the mappings for each of them.
```json

{
  "mappings": {
    "properties": {
      "topics": {
        "type": "rank_features" <1>
      },
      "negative_reviews" : {
        "type": "rank_features",
        "positive_score_impact": false <2>
      }
    }
  }
}


{
  "topics": { <3>
    "politics": 20,
    "economics": 50.8
  },
  "negative_reviews": {
    "1star": 10,
    "2star": 100
  }
}


{
  "topics": {
    "politics": 5.2,
    "sports": 80.1
  },
  "negative_reviews": {
    "1star": 1,
    "2star": 10
  }
}


{
  "query": { <4>
    "rank_feature": {
      "field": "topics.politics"
    }
  }
}


{
  "query": { <5>
    "rank_feature": {
      "field": "negative_reviews.1star"
    }
  }
}


{
  "query": { <6>
    "term": {
      "topics": "economics"
    }
  }
}
```

<note>
  `rank_features` fields only support single-valued features and strictly positive values. Multi-valued fields and zero or negative values will be rejected.
</note>

<note>
  `rank_features` fields do not support sorting or aggregating and may only be queried using [`rank_feature`](https://www.elastic.co/docs/reference/query-languages/query-dsl/query-dsl-rank-feature-query) or [`term`](https://www.elastic.co/docs/reference/query-languages/query-dsl/query-dsl-term-query) queries.
</note>

<note>
  [`term`](https://www.elastic.co/docs/reference/query-languages/query-dsl/query-dsl-term-query) queries on `rank_features` fields are scored by multiplying the matched stored feature value by the provided `boost`.
</note>

<note>
  `rank_features` fields only preserve 9 significant bits for the precision, which translates to a relative error of about 0.4%.
</note>

Rank features that correlate negatively with the score should set `positive_score_impact` to `false` (defaults to `true`). This will be used by the [`rank_feature`](https://www.elastic.co/docs/reference/query-languages/query-dsl/query-dsl-rank-feature-query) query to modify the scoring formula in such a way that the score decreases with the value of the feature instead of increasing.