﻿---
title: Rank feature field type
description: A rank_feature field can index numbers so that they can later be used to boost documents in queries with a rank_feature query. Rank features that correlate...
url: https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/rank-feature
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Rank feature field type
A `rank_feature` field can index numbers so that they can later be used to boost documents in queries with a [`rank_feature`](https://www.elastic.co/docs/reference/query-languages/query-dsl/query-dsl-rank-feature-query) query.
```json

{
  "mappings": {
    "properties": {
      "pagerank": {
        "type": "rank_feature" <1>
      },
      "url_length": {
        "type": "rank_feature",
        "positive_score_impact": false <2>
      }
    }
  }
}


{
  "pagerank": 8,
  "url_length": 22
}


{
  "query": {
    "rank_feature": {
      "field": "pagerank"
    }
  }
}
```

<note>
  `rank_feature` fields only support single-valued fields and strictly positive values. Multi-valued fields and negative values will be rejected.
</note>

<note>
  `rank_feature` fields do not support querying, sorting or aggregating. They may only be used within [`rank_feature`](https://www.elastic.co/docs/reference/query-languages/query-dsl/query-dsl-rank-feature-query) queries.
</note>

<note>
  `rank_feature` fields only preserve 9 significant bits for the precision, which translates to a relative error of about 0.4%.
</note>

Rank features that correlate negatively with the score should set `positive_score_impact` to `false` (defaults to `true`). This will be used by the [`rank_feature`](https://www.elastic.co/docs/reference/query-languages/query-dsl/query-dsl-rank-feature-query) query to modify the scoring formula in such a way that the score decreases with the value of the feature instead of increasing. For instance in web search, the url length is a commonly used feature which correlates negatively with scores.