﻿---
title: properties
description: Type mappings, object fields and nested fields contain sub-fields, called properties. These properties may be of any data type, including object and nested...
url: https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/properties
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# properties
Type mappings, [`object` fields](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/object) and [`nested` fields](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/nested) contain sub-fields, called `properties`. These properties may be of any [data type](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/field-data-types), including `object` and `nested`. Properties can be added:
- explicitly by defining them when [creating an index](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-create).
- explicitly by defining them when adding or updating a mapping type with the [update mapping](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-put-mapping) API.
- [dynamically](https://www.elastic.co/docs/manage-data/data-store/mapping/dynamic-mapping) just by indexing documents containing new fields.

Below is an example of adding `properties` to a mapping type, an `object` field, and a `nested` field:
```json

{
  "mappings": {
    "properties": { <1>
      "manager": {
        "properties": { <2>
          "age":  { "type": "integer" },
          "name": { "type": "text"  }
        }
      },
      "employees": {
        "type": "nested",
        "properties": { <3>
          "age":  { "type": "integer" },
          "name": { "type": "text"  }
        }
      }
    }
  }
}


{
  "region": "US",
  "manager": {
    "name": "Alice White",
    "age": 30
  },
  "employees": [
    {
      "name": "John Smith",
      "age": 34
    },
    {
      "name": "Peter Brown",
      "age": 26
    }
  ]
}
```

<tip>
  The `properties` setting is allowed to have different settings for fields of the same name in the same index. New properties can be added to existing fields using the [update mapping API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-put-mapping).
</tip>


## Dot notation

Inner fields can be referred to in queries, aggregations, etc., using *dot notation*:
```json

{
  "query": {
    "match": {
      "manager.name": "Alice White"
    }
  },
  "aggs": {
    "Employees": {
      "nested": {
        "path": "employees"
      },
      "aggs": {
        "Employee Ages": {
          "histogram": {
            "field": "employees.age",
            "interval": 5
          }
        }
      }
    }
  }
}
```

<important>
  The full path to the inner field must be specified.
</important>