﻿---
title: position_increment_gap
description: Analyzed text fields take term positions into account, in order to be able to support proximity or phrase queries. When indexing text fields with multiple...
url: https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/position-increment-gap
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# position_increment_gap
[Analyzed](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/mapping-index) text fields take term [positions](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/index-options) into account, in order to be able to support [proximity or phrase queries](https://www.elastic.co/docs/reference/query-languages/query-dsl/query-dsl-match-query-phrase). When indexing text fields with multiple values a "fake" gap is added between the values to prevent most phrase queries from matching across the values. The size of this gap is configured using `position_increment_gap` and defaults to `100`.
For example:
```json

{
  "names": [ "John Abraham", "Lincoln Smith"]
}


{
  "query": {
    "match_phrase": {
      "names": {
        "query": "Abraham Lincoln" <1>
      }
    }
  }
}


{
  "query": {
    "match_phrase": {
      "names": {
        "query": "Abraham Lincoln",
        "slop": 101 <2>
      }
    }
  }
}
```

The `position_increment_gap` can be specified in the mapping. For instance:
```json

{
  "mappings": {
    "properties": {
      "names": {
        "type": "text",
        "position_increment_gap": 0 <1>
      }
    }
  }
}


{
  "names": [ "John Abraham", "Lincoln Smith"]
}


{
  "query": {
    "match_phrase": {
      "names": "Abraham Lincoln" <2>
    }
  }
}
```