﻿---
title: Point field type
description: The point data type facilitates the indexing of and searching arbitrary x, y pairs that fall in a 2-dimensional planar coordinate system. You can query...
url: https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/point
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Point field type
The `point` data type facilitates the indexing of and searching arbitrary `x, y` pairs that fall in a 2-dimensional planar coordinate system.
You can query documents using this type using [shape Query](https://www.elastic.co/docs/reference/query-languages/query-dsl/query-dsl-shape-query).
As with [geo_shape](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/geo-shape) and [geo_point](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/geo-point), `point` can be specified in [GeoJSON](http://geojson.org) and [Well-Known Text](https://docs.opengeospatial.org/is/12-063r5/12-063r5.html) formats. However, there are a number of additional formats that are supported for convenience and historical reasons. In total there are five ways that a cartesian point may be specified, as demonstrated below:
```json

{
  "mappings": {
    "properties": {
      "location": {
        "type": "point"
      }
    }
  }
}


{
  "text": "Point as an object using GeoJSON format",
  "location": { <1>
    "type": "Point",
    "coordinates": [-71.34, 41.12]
  }
}


{
  "text": "Point as a WKT POINT primitive",
  "location" : "POINT (-71.34 41.12)" <2>
}


{
  "text": "Point as an object with 'x' and 'y' keys",
  "location": { <3>
    "x": -71.34,
    "y": 41.12
  }
}


{
  "text": "Point as an array",
  "location": [ -71.34, 41.12 ] <4>
}


{
  "text": "Point as a string",
  "location": "-71.34,41.12" <5>
}
```

<note>
  Unlike the case with the [geo-point](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/geo-point) field type, the order of the coordinates `x` and `y` is the same for all formats above.
</note>

The coordinates provided to the indexer are single precision floating point values so the field guarantees the same accuracy provided by the java virtual machine (typically `1E-38`).

## Parameters for `point` fields

The following parameters are accepted by `point` fields:
<definitions>
  <definition term="ignore_malformed">
    If `true`, malformed points are ignored. If `false` (default), malformed points throw an exception and reject the whole document.
  </definition>
  <definition term="ignore_z_value">
    If `true` (default) three dimension points will be accepted (stored in source) but only x and y values will be indexed; the third dimension is ignored. If `false`, points containing any more than x and y (two dimensions) values throw an exception and reject the whole document.
  </definition>
  <definition term="null_value">
    Accepts an point value which is substituted for any explicit `null` values. Defaults to `null`, which means the field is treated as missing.
  </definition>
</definitions>


## Sorting and retrieving points

It is currently not possible to sort points or retrieve their fields directly. The `point` value is only retrievable through the `_source` field.