﻿---
title: Pattern text field type
description: The pattern_text field type is a variant of text with improved space efficiency for log data. Internally, it decomposes values into static parts that...
url: https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/pattern-text
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Pattern text field type
<applies-to>
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available since 9.3
  - Elastic Stack: Preview in 9.2
</applies-to>

<note>
  This feature requires a [subscription](https://www.elastic.co/subscriptions)
</note>

The `pattern_text` field type is a variant of [`text`](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/text) with improved space efficiency for log data.
Internally, it decomposes values into static parts that are likely to be shared among many values, and dynamic parts that tend to vary.
The static parts usually come from the explanatory text of a log message, while the dynamic parts are the variables that were interpolated into the logs.
This decomposition allows for improved compression on log-like data.
We call the static portion of the value the `template`.
Although the template cannot be accessed directly, a separate field called `<field_name>.template_id` is accessible.
This field is a hash of the template and can be used to group similar values.
Analysis is configurable but defaults to a delimiter-based analyzer.
This analyzer applies a lowercase filter and then splits on whitespace and the following delimiters: `=`, `?`, `:`, `[`, `]`, `{`, `}`, `"`, `\`, `'`.

## Limitations

Unlike most mapping types, `pattern_text` does not support multiple values for a given field per document.
If a document is created with multiple values for a pattern_text field, an error will be returned.
[span queries](https://www.elastic.co/docs/reference/query-languages/query-dsl/span-queries) are not supported with this field, use [interval queries](https://www.elastic.co/docs/reference/query-languages/query-dsl/query-dsl-intervals-query) instead, or the [`text`](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/text) field type if you absolutely need span queries.
Like `text`, `pattern_text` does not support sorting and has only limited support for aggregations.

## Phrase matching

Pattern text supports an `index_options` parameter with valid values of `docs` and `positions`.
The default value is `docs`, which makes `pattern_text` behave similarly to `match_only_text` for phrase queries.
Specifically, positions are not stored, which reduces the index size at the cost of slowing down phrase queries.
If `index_options` is set to `positions`, positions are stored and `pattern_text` will support fast phrase queries.
In both cases, all queries return a constant score of 1.0.

## Index sorting for improved compression

The compression provided by `pattern_text` can be significantly improved if the index is sorted by the `template_id` field.

### Default sorting for LogsDB

<applies-to>
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available since 9.3
</applies-to>

This index sorting is not applied by default, but can be enabled for the `message` field of LogsDB indices (assuming it is of type `pattern_text`) by setting the index setting `index.logsdb.default_sort_on_message_template` to `true`.
This will cause the index to be sorted by `host.name` (if present), then `message.template_id`, and finally by `@timestamp`.

### Custom sorting

If the index is not LogsDB or the `pattern_text` field is named something other than `message`, index sorting can still be manually applied as shown in the following example.
```json

{
  "settings": {
    "index": {
      "sort.field": [ "notice.template_id", "@timestamp" ],
      "sort.order": [ "asc", "desc" ]
    }
  },
  "mappings": {
    "properties": {
      "@timestamp": {
        "type": "date"
      },
      "notice": {
        "type": "pattern_text"
      }
    }
  }
}
```


## Parameters for pattern text fields

The following mapping parameters are accepted:
<definitions>
  <definition term="analyzer">
    The [analyzer](https://www.elastic.co/docs/manage-data/data-store/text-analysis) which should be used for the `pattern_text` field, both at index-time and at search-time (unless overridden by the  [`search_analyzer`](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/search-analyzer)).
    Supports a delimiter-based analyzer and the standard analyzer, as is used in `match_only_text` mappings.
    Defaults to the delimiter-based analyzer, which applies a lowercase filter and then splits on whitespace and the following delimiters: `=`, `?`, `:`, `[`, `]`, `{`, `}`, `"`, `\`, `'`.
  </definition>
  <definition term="index_options">
    What information should be stored in the index, for search and highlighting purposes. Valid values are `docs` and `positions`. Defaults to `docs`.
  </definition>
  <definition term="meta">
    Metadata about the field.
  </definition>
</definitions>