﻿---
title: Object field type
description: JSON documents are hierarchical in nature: the document may contain inner objects which, in turn, may contain inner objects themselves: Internally, this...
url: https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/object
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Object field type
JSON documents are hierarchical in nature: the document may contain inner objects which, in turn, may contain inner objects themselves:
```json

{ // <1>
  "region": "US",
  "manager": { <2>
    "age":     30,
    "name": { <3>
      "first": "John",
      "last":  "Smith"
    }
  }
}
```

Internally, this document is indexed as a simple, flat list of key-value pairs, something like this:
```js
{
  "region":             "US",
  "manager.age":        30,
  "manager.name.first": "John",
  "manager.name.last":  "Smith"
}
```

An explicit mapping for the above document could look like this:
```json

{
  "mappings": {
    "properties": { <1>
      "region": {
        "type": "keyword"
      },
      "manager": { <2>
        "properties": {
          "age":  { "type": "integer" },
          "name": { <3>
            "properties": {
              "first": { "type": "text" },
              "last":  { "type": "text" }
            }
          }
        }
      }
    }
  }
}
```

You are not required to set the field `type` to `object` explicitly, as this is the default value.

## Parameters for `object` fields

The following parameters are accepted by `object` fields:
<definitions>
  <definition term="dynamic">
    Whether or not new `properties` should be added dynamically to an existing object. Accepts `true` (default), `runtime`, `false` and `strict`.
  </definition>
  <definition term="enabled">
    Whether the JSON value given for the object field should be parsed and indexed (`true`, default) or completely ignored (`false`).
  </definition>
  <definition term="subobjects">
    Whether the object can hold subobjects (`true`, default) or not (`false`). If not, sub-fields with dots in their names will be treated as leaves instead, otherwise their field names would be expanded to their corresponding object structure.
  </definition>
  <definition term="properties">
    The fields within the object, which can be of any [data type](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/field-data-types), including `object`. New properties may be added to an existing object.
  </definition>
</definitions>

<important>
  If you need to index arrays of objects instead of single objects, read [Nested](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/nested) first.
</important>