﻿---
title: null_value
description: A null value cannot be indexed or searched. When a field is set to null, (or an empty array or an array of null values)  it is treated as though that...
url: https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/null-value
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# null_value
A `null` value cannot be indexed or searched. When a field is set to `null`, (or an empty array or an array of `null` values)  it is treated as though that field has no values.
The `null_value` parameter allows you to replace explicit `null` values with the specified value so that it can be indexed and searched. For instance:
```json

{
  "mappings": {
    "properties": {
      "status_code": {
        "type":       "keyword",
        "null_value": "NULL" <1>
      }
    }
  }
}


{
  "status_code": null
}


{
  "status_code": [] <2>
}


{
  "query": {
    "term": {
      "status_code": "NULL" <3>
    }
  }
}
```

<important>
  The `null_value` needs to be the same data type as the field. For instance, a `long` field cannot have a string `null_value`.
</important>

<note>
  The `null_value` only influences how data is indexed, it doesn’t modify the `_source` document.
</note>