﻿---
title: store
description: By default, field values are indexed to make them searchable, but they are not stored. This means that the field can be queried, but the original field...
url: https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/mapping-store
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# store
By default, field values are [indexed](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/mapping-index) to make them searchable, but they are not *stored*. This means that the field can be queried, but the original field value cannot be retrieved.
Usually this doesn’t matter. The field value is already part of the [`_source` field](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/mapping-source-field), which is stored by default. If you only want to retrieve the value of a single field or of a few fields, instead of the whole `_source`, then this can be achieved with [source filtering](/docs/reference/elasticsearch/rest-apis/retrieve-selected-fields#source-filtering).
In certain situations it can make sense to `store` a field. For instance, if you have a document with a `title`, a `date`, and a very large `content` field, you may want to retrieve just the `title` and the `date` without having to extract those fields from a large `_source` field:
```json

{
  "mappings": {
    "properties": {
      "title": {
        "type": "text",
        "store": true <1>
      },
      "date": {
        "type": "date",
        "store": true <1>
      },
      "content": {
        "type": "text"
      }
    }
  }
}


{
  "title":   "Some short title",
  "date":    "2015-01-01",
  "content": "A very long content field..."
}


{
  "stored_fields": [ "title", "date" ] <2>
}
```

<admonition title="Stored fields returned as arrays">
  For consistency, stored fields are always returned as an *array* because there is no way of knowing if the original field value was a single value, multiple values, or an empty array.If you need the original value, you should retrieve it from the `_source` field instead.
</admonition>