﻿---
title: _meta field
description: A mapping type can have custom meta data associated with it. These are not used at all by Elasticsearch, but can be used to store application-specific...
url: https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/mapping-meta-field
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# _meta field
A mapping type can have custom meta data associated with it. These are not used at all by Elasticsearch, but can be used to store application-specific metadata, such as the class that a document belongs to:
```json

{
  "mappings": {
    "_meta": { <1>
      "class": "MyApp::User",
      "version": {
        "min": "1.0",
        "max": "1.3"
      }
    }
  }
}
```

The `_meta` field can be updated on an existing type using the [update mapping](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-put-mapping) API:
```json

{
  "_meta": {
    "class": "MyApp2::User3",
    "version": {
      "min": "1.3",
      "max": "1.5"
    }
  }
}
```