﻿---
title: _index field
description: When performing queries across multiple indexes, it is sometimes desirable to add query clauses that are associated with documents of only certain indexes...
url: https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/mapping-index-field
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# _index field
When performing queries across multiple indexes, it is sometimes desirable to add query clauses that are associated with documents of only certain indexes. The `_index` field allows matching on the index a document was indexed into. Its value is accessible in certain queries and aggregations, and when sorting or scripting:
```json

{
  "text": "Document in index 1"
}


{
  "text": "Document in index 2"
}


{
  "query": {
    "terms": {
      "_index": ["index_1", "index_2"] <1>
    }
  },
  "aggs": {
    "indices": {
      "terms": {
        "field": "_index", <2>
        "size": 10
      }
    }
  },
  "sort": [
    {
      "_index": { <3>
        "order": "asc"
      }
    }
  ],
  "script_fields": {
    "index_name": {
      "script": {
        "lang": "painless",
        "source": "doc['_index']" <4>
      }
    }
  }
}
```

The `_index` field is exposed virtually — it is not added to the Lucene index as a real field. This means that you can use the `_index` field in a `term` or `terms` query (or any query that is rewritten to a `term` query, such as the `match`,  `query_string` or `simple_query_string` query), as well as `prefix` and `wildcard` queries. However, it does not support `regexp` and `fuzzy` queries.
Queries on the `_index` field accept index aliases in addition to concrete index names.
<note>
  When specifying a remote index name such as `cluster_1:index_3`, the query must contain the separator character `:`. For example, a `wildcard` query on `cluster_*:index_3` would match documents from the remote index. However, a query on `cluster*index_1` is only matched against local indices, since no separator is present. This behavior aligns with the usual resolution rules for remote index names.
</note>