﻿---
title: _ignored field
description: The _ignored field indexes and stores the names of every field in a document that has been ignored when the document was indexed. This can, for example,...
url: https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/mapping-ignored-field
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# _ignored field
The `_ignored` field indexes and stores the names of every field in a document that has been ignored when the document was indexed. This can, for example, be the case when the field was malformed and [`ignore_malformed`](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/ignore-malformed) was turned on, when a `keyword` field’s value exceeds its optional [`ignore_above`](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/ignore-above) setting, or when `index.mapping.total_fields.limit` has been reached and `index.mapping.total_fields.ignore_dynamic_beyond_limit` is set to `true`. For more index setting details, refer to [Mapping limit settings](https://www.elastic.co/docs/reference/elasticsearch/index-settings/mapping-limit).
This field is searchable with [`term`](https://www.elastic.co/docs/reference/query-languages/query-dsl/query-dsl-term-query), [`terms`](https://www.elastic.co/docs/reference/query-languages/query-dsl/query-dsl-terms-query) and [`exists`](https://www.elastic.co/docs/reference/query-languages/query-dsl/query-dsl-exists-query) queries, and is returned as part of the search hits.
For instance the below query matches all documents that have one or more fields that got ignored:
```json

{
  "query": {
    "exists": {
      "field": "_ignored"
    }
  }
}
```

Similarly, the below query finds all documents whose `@timestamp` field was ignored at index time:
```json

{
  "query": {
    "term": {
      "_ignored": "@timestamp"
    }
  }
}
```

Since 8.15.0, the `_ignored` field supports aggregations as well. For example, the below query finds all fields that got ignored:
```json

{
  "aggs": {
    "ignored_fields": {
      "terms": {
         "field": "_ignored"
      }
    }
  }
}
```